
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.exported_message_link import TypeExportedMessageLink


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class ExportMessageLink(TLRequest[TypeExportedMessageLink]):
    """
    Get link and embed info of a message in a [channel/supergroup](https://core.telegram.org/api/channel)

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.

    """

    _id = 0XE63FADEB
    _result_id = 0X1BA4744A

    def __init__(
        self,
        channel: 'TypeInputChannel',
        id: int,
        grouped: bool = False,
        thread: bool = False
    ):

        """
        Get link and embed info of a message in a [channel/supergroup](https://core.telegram.org/api/channel)

        Args:
            channel ('TypeInputChannel'): Channel
            id (int): Message ID
            grouped (bool, optional): Whether to include other grouped media (for albums)
            thread (bool, optional): Whether to also include a thread ID, if available, inside of the link
        """

        self.channel = channel
        self.id = id
        self.grouped = grouped
        self.thread = thread

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeb\xad?\xe6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.grouped, 0)
                flags(self.thread, 1)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.int(self.id)

            return writer.getvalue()