
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.forum_topics import TypeMessagesForumTopics


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class GetForumTopics(TLRequest[TypeMessagesForumTopics]):
    """
    Get [topics of a forum](https://core.telegram.org/api/forum)

    Raises:
        `400`ChannelForumMissingError: This supergroup is not a forum.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.

    """

    _id = 0XDE560D1
    _result_id = 0X1C080881

    def __init__(
        self,
        channel: 'TypeInputChannel',
        offset_date: int,
        offset_id: int,
        offset_topic: int,
        limit: int,
        q: Optional[str] = None
    ):

        """
        Get [topics of a forum](https://core.telegram.org/api/forum)

        Args:
            channel ('TypeInputChannel'): Supergroup
            offset_date (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets), date of the last message of the last found topic. Use 0 or any date in the future to get results from the last topic.
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets), ID of the last message of the last found topic (or initially 0).
            offset_topic (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets), ID of the last found topic (or initially 0).
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets). For optimal performance, the number of returned topics is chosen by the server and can be smaller than the specified limit.
            q (Optional[str], optional): Search query
        """

        self.channel = channel
        self.offset_date = offset_date
        self.offset_id = offset_id
        self.offset_topic = offset_topic
        self.limit = limit
        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd1`\xe5\r' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )

                if flags(self.q, 0):
                    writer.string(self.q)
                writer.int(self.offset_date)
                writer.int(self.offset_id)
                writer.int(self.offset_topic)
                writer.int(self.limit)

            return writer.getvalue()