
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_channel import TypeInputChannel


class ReportSpam(TLRequest[bool]):
    """
    Reports some messages from a user in a supergroup as spam; requires administrator rights in the supergroup

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`UserIdInvalidError: The provided user ID is invalid.

    """

    _id = 0XF44A8315
    _result_id = 0X43B904E1

    def __init__(
        self,
        channel: 'TypeInputChannel',
        participant: 'TypeInputPeer',
        id: List[int]
    ):

        """
        Reports some messages from a user in a supergroup as spam; requires administrator rights in the supergroup

        Args:
            channel ('TypeInputChannel'): Supergroup
            participant ('TypeInputPeer'): Participant whose messages should be reported
            id (List[int]): IDs of spam messages
        """

        self.channel = channel
        self.participant = participant
        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x15\x83J\xf4' if boxed else b'') as writer:
            writer.object(
                self.channel,
                group_id=0X42691CEF
            )
            writer.object(
                self.participant,
                group_id=0X995DB9DF
            )
            writer.vector(
                self.id,
                writer.int
            )

            return writer.getvalue()