
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class JoinChatlistInvite(TLRequest[TypeUpdates]):
    """
    Import a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links), joining some or all the chats in the folder.

    Raises:
        `400`FilterIncludeEmptyError: The include_peers vector of the filter is empty.
        `400`InviteSlugEmptyError: The specified invite slug is empty.
        `400`InviteSlugExpiredError: The specified chat folder link has expired.

    """

    _id = 0XA6B1E39A
    _result_id = 0XD68D29C0

    def __init__(
        self,
        slug: str,
        peers: List['TypeInputPeer']
    ):

        """
        Import a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links), joining some or all the chats in the folder.

        Args:
            slug (str): slug obtained from a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
            peers (List['TypeInputPeer']): List of new chats to join, fetched using [chatlists.checkChatlistInvite](https://core.telegram.org/method/chatlists.checkChatlistInvite) and filtered as specified in the [documentation](https://core.telegram.org/api/folders#shared-folders).
        """

        self.slug = slug
        self.peers = peers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9a\xe3\xb1\xa6' if boxed else b'') as writer:
            writer.string(self.slug)
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0X995DB9DF
                )
            )

            return writer.getvalue()