
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.encrypted_chat import TypeEncryptedChat


if TYPE_CHECKING:
    from ...types.input_encrypted_chat import TypeInputEncryptedChat


class AcceptEncryption(TLRequest[TypeEncryptedChat]):
    """
    Confirms creation of a secret chat

    Raises:
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`EncryptionAlreadyAcceptedError: Secret chat already accepted.
        `400`EncryptionAlreadyDeclinedError: The secret chat was already declined.

    """

    _id = 0X3DBC0415
    _result_id = 0X9E93492C

    def __init__(
        self,
        peer: 'TypeInputEncryptedChat',
        g_b: bytes,
        key_fingerprint: int
    ):

        """
        Confirms creation of a secret chat

        Args:
            peer ('TypeInputEncryptedChat'): Secret chat ID
            g_b (bytes): B = g ^ b mod p, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
            key_fingerprint (int): 64-bit fingerprint of the received key
        """

        self.peer = peer
        self.g_b = g_b
        self.key_fingerprint = key_fingerprint

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x15\x04\xbc=' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X947D3E78
            )
            writer.bytes(self.g_b)
            writer.long(self.key_fingerprint)

            return writer.getvalue()