
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.chat_banned_rights import TypeChatBannedRights


class EditChatDefaultBannedRights(TLRequest[TypeUpdates]):
    """
    Edit the default banned rights of a [channel/supergroup/group](https://core.telegram.org/api/channel).

    **Bots can use this method**

    Raises:
        `400`BannedRightsInvalidError: You provided some invalid flags in the banned rights.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UntilDateInvalidError: Invalid until date provided.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0XA5866B41
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        banned_rights: 'TypeChatBannedRights'
    ):

        """
        Edit the default banned rights of a [channel/supergroup/group](https://core.telegram.org/api/channel).

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): The peer
            banned_rights ('TypeChatBannedRights'): The new global rights
        """

        self.peer = peer
        self.banned_rights = banned_rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Ak\x86\xa5' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.object(
                self.banned_rights,
                group_id=0XDB47663A
            )

            return writer.getvalue()