
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.dh_config import TypeMessagesDhConfig


class GetDhConfig(TLRequest[TypeMessagesDhConfig]):
    """
    Returns configuration parameters for Diffie-Hellman key generation. Can also return a random sequence of bytes of required length.

    Raises:
        `400`RandomLengthInvalidError: Random length invalid.

    """

    _id = 0X26CF8950
    _result_id = 0XF887775D

    def __init__(
        self,
        version: int,
        random_length: int
    ):

        """
        Returns configuration parameters for Diffie-Hellman key generation. Can also return a random sequence of bytes of required length.

        Args:
            version (int): Value of the version parameter from [messages.dhConfig](https://core.telegram.org/constructor/messages.dhConfig), available at the client
            random_length (int): Length of the required random sequence
        """

        self.version = version
        self.random_length = random_length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'P\x89\xcf&' if boxed else b'') as writer:
            writer.int(self.version)
            writer.int(self.random_length)

            return writer.getvalue()