
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ...types.document import TypeDocument
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class GetDocumentByHash(TLRequest[TypeDocument]):
    """
    Get a document by its SHA256 hash, mainly used for gifs

    **Bots can use this method**

    Raises:
        `400`Sha256HashInvalidError: The provided SHA256 hash is invalid.

    """

    _id = 0XB1F2061F
    _result_id = 0X6547BD50

    def __init__(
        self,
        sha256: bytes,
        size: int,
        mime_type: str
    ):

        """
        Get a document by its SHA256 hash, mainly used for gifs

        **Bots can use this method**

        Args:
            sha256 (bytes): SHA256 of file
            size (int): Size of the file in bytes
            mime_type (str): Mime type
        """

        self.sha256 = sha256
        self.size = size
        self.mime_type = mime_type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1f\x06\xf2\xb1' if boxed else b'') as writer:
            writer.bytes(self.sha256)
            writer.long(self.size)
            writer.string(self.mime_type)

            return writer.getvalue()