
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser
    from ...types.input_reply_to import TypeInputReplyTo


class ProlongWebView(TLRequest[bool]):
    """
    Indicate to the server (from the user side) that the user is still using a web app.

    Raises:
        `400`BotInvalidError: This is not a valid bot.

    """

    _id = 0XB0D81A83
    _result_id = 0X43B904E1

    def __init__(
        self,
        peer: 'TypeInputPeer',
        bot: 'TypeInputUser',
        query_id: int,
        silent: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        send_as: Optional['TypeInputPeer'] = None
    ):

        """
        Indicate to the server (from the user side) that the user is still using a web app.

        Args:
            peer ('TypeInputPeer'): Dialog where the web app was opened.
            bot ('TypeInputUser'): Bot that owns the [web app](https://core.telegram.org/api/bots/webapps)
            query_id (int): Web app interaction ID obtained from [messages.requestWebView](https://core.telegram.org/method/messages.requestWebView)
            silent (bool, optional): Whether the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://core.telegram.org/method/messages.sendWebViewResultMessage) should be sent silently (no notifications for the receivers).
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://core.telegram.org/method/messages.sendWebViewResultMessage) should be sent in reply to the specified message or story.
            send_as (Optional['TypeInputPeer'], optional): Open the web app as the specified peer
        """

        self.peer = peer
        self.bot = bot
        self.query_id = query_id
        self.silent = silent
        self.reply_to = reply_to
        self.send_as = send_as

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x83\x1a\xd8\xb0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 5)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )
                writer.long(self.query_id)

                if flags(self.reply_to, 0):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

            return writer.getvalue()