
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.web_view_result import TypeWebViewResult


if TYPE_CHECKING:
    from ...types.data_json import TypeDataJSON
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser
    from ...types.input_reply_to import TypeInputReplyTo


class RequestWebView(TLRequest[TypeWebViewResult]):
    """
    Open a [bot mini app](https://core.telegram.org/bots/webapps), sending over user information after user confirmation.

    Raises:
        `400`BotInvalidError: This is not a valid bot.
        `400`BotWebviewDisabledError: A webview cannot be opened in the specified conditions: emitted for example if `from_bot_menu` or `url` are set and `peer` is not the chat with the bot.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`SendAsPeerInvalidError: You can't send messages as the specified peer.
        `400`ThemeParamsInvalidError: The specified `theme_params` field is invalid.
        `400`UrlInvalidError: Invalid URL provided.
        `400`YouBlockedUserError: You blocked this user.
        `403`PrivacyPremiumRequiredError: You need a [Telegram Premium subscription](https://core.telegram.org/api/premium) to send a message to this user.

    """

    _id = 0X269DC2C1
    _result_id = 0X60754D10

    def __init__(
        self,
        peer: 'TypeInputPeer',
        bot: 'TypeInputUser',
        platform: str,
        from_bot_menu: bool = False,
        silent: bool = False,
        compact: bool = False,
        fullscreen: bool = False,
        url: Optional[str] = None,
        start_param: Optional[str] = None,
        theme_params: Optional['TypeDataJSON'] = None,
        reply_to: Optional['TypeInputReplyTo'] = None,
        send_as: Optional['TypeInputPeer'] = None
    ):

        """
        Open a [bot mini app](https://core.telegram.org/bots/webapps), sending over user information after user confirmation.

        Args:
            peer ('TypeInputPeer'): Dialog where the web app is being opened, and where the resulting message will be sent (see the [docs for more info](https://core.telegram.org/api/bots/webapps)).
            bot ('TypeInputUser'): Bot that owns the [web app](https://core.telegram.org/api/bots/webapps)
            platform (str): Short name of the application; 0-64 English letters, digits, and underscores
            from_bot_menu (bool, optional): Whether the webview was opened by clicking on the bot's [menu button](https://core.telegram.org/api/bots/menu).
            silent (bool, optional): Whether the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://core.telegram.org/method/messages.sendWebViewResultMessage) should be sent silently (no notifications for the receivers).
            compact (bool, optional): If set, requests to open the mini app in compact mode (as opposed to normal or fullscreen mode). Must be set if the mode parameter of the [attachment menu deep link](https://core.telegram.org/api/links#bot-attachment-or-side-menu-links) is equal to compact.
            fullscreen (bool, optional): If set, requests to open the mini app in fullscreen mode (as opposed to normal or compact mode). Must be set if the mode parameter of the [attachment menu deep link](https://core.telegram.org/api/links#bot-attachment-or-side-menu-links) is equal to fullscreen.
            url (Optional[str], optional): [Web app URL](https://core.telegram.org/api/bots/webapps)
            start_param (Optional[str], optional): If the web app was opened from the attachment menu using a [attachment menu deep link](https://core.telegram.org/api/links#bot-attachment-or-side-menu-links), start_param should contain the data from the startattach parameter.
            theme_params (Optional['TypeDataJSON'], optional): [Theme parameters](https://core.telegram.org/api/bots/webapps#theme-parameters)
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the inline message that will be sent by the bot on behalf of the user once the web app interaction is [terminated](https://core.telegram.org/method/messages.sendWebViewResultMessage) should be sent in reply to the specified message or story.
            send_as (Optional['TypeInputPeer'], optional): Open the web app as the specified peer, sending the resulting the message as the specified peer.
        """

        self.peer = peer
        self.bot = bot
        self.platform = platform
        self.from_bot_menu = from_bot_menu
        self.silent = silent
        self.compact = compact
        self.fullscreen = fullscreen
        self.url = url
        self.start_param = start_param
        self.theme_params = theme_params
        self.reply_to = reply_to
        self.send_as = send_as

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc1\xc2\x9d&' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.from_bot_menu, 4)
                flags(self.silent, 5)
                flags(self.compact, 7)
                flags(self.fullscreen, 8)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )

                if flags(self.url, 1):
                    writer.string(self.url)

                if flags(self.start_param, 3):
                    writer.string(self.start_param)

                if flags(self.theme_params, 2):
                    writer.object(
                        self.theme_params,
                        group_id=0XE95B0798
                    )
                writer.string(self.platform)

                if flags(self.reply_to, 0):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

            return writer.getvalue()