
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_media import TypeInputMedia
    from ...types.input_reply_to import TypeInputReplyTo
    from ...types.message_entity import TypeMessageEntity
    from ...types.suggested_post import TypeSuggestedPost


class SaveDraft(TLRequest[bool]):
    """
    Save a message [draft](https://core.telegram.org/api/drafts) associated to a chat.

    Raises:
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X54AE308E
    _result_id = 0X43B904E1

    def __init__(
        self,
        peer: 'TypeInputPeer',
        message: str,
        no_webpage: bool = False,
        invert_media: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        media: Optional['TypeInputMedia'] = None,
        effect: Optional[int] = None,
        suggested_post: Optional['TypeSuggestedPost'] = None
    ):

        """
        Save a message [draft](https://core.telegram.org/api/drafts) associated to a chat.

        Args:
            peer ('TypeInputPeer'): Destination of the message that should be sent
            message (str): The draft
            no_webpage (bool, optional): Disable generation of the webpage preview
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the message should be sent in reply to the specified message or story.
            entities (Optional[List['TypeMessageEntity']], optional): Message [entities](https://core.telegram.org/api/entities) for styled text
            media (Optional['TypeInputMedia'], optional): Attached media
            effect (Optional[int], optional): Specifies a [message effect](https://core.telegram.org/api/effects) to use for the message.
            suggested_post (Optional['TypeSuggestedPost'], optional): ...
        """

        self.peer = peer
        self.message = message
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.reply_to = reply_to
        self.entities = entities
        self.media = media
        self.effect = effect
        self.suggested_post = suggested_post

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8e0\xaeT' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 1)
                flags(self.invert_media, 6)

                if flags(self.reply_to, 4):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.message)

                if flags(self.entities, 3):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.media, 5):
                    writer.object(
                        self.media,
                        group_id=0XCEC6DE21
                    )

                if flags(self.effect, 7):
                    writer.long(self.effect)

                if flags(self.suggested_post, 8):
                    writer.object(
                        self.suggested_post,
                        group_id=0X7DC96856
                    )

            return writer.getvalue()