
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.bot_prepared_inline_message import TypeMessagesBotPreparedInlineMessage


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.inline_query_peer_type import TypeInlineQueryPeerType
    from ...types.input_bot_inline_result import TypeInputBotInlineResult


class SavePreparedInlineMessage(TLRequest[TypeMessagesBotPreparedInlineMessage]):
    """
    Save a [prepared inline message](https://core.telegram.org/api/bots/inline#21-using-a-prepared-inline-message), to be shared by the user of the mini app using a [web_app_send_prepared_message event](https://core.telegram.org/api/web-events#web-app-send-prepared-message)

    **Bots can use this method**

    Raises:
        `400`ResultIdInvalidError: One of the specified result IDs is invalid.
        `400`UserBotRequiredError: This method can only be called by a bot.
        `400`UserIdInvalidError: The provided user ID is invalid.

    """

    _id = 0XF21F7F2F
    _result_id = 0X3D67ECFA

    def __init__(
        self,
        result: 'TypeInputBotInlineResult',
        user_id: 'TypeInputUser',
        peer_types: Optional[List['TypeInlineQueryPeerType']] = None
    ):

        """
        Save a [prepared inline message](https://core.telegram.org/api/bots/inline#21-using-a-prepared-inline-message), to be shared by the user of the mini app using a [web_app_send_prepared_message event](https://core.telegram.org/api/web-events#web-app-send-prepared-message)

        **Bots can use this method**

        Args:
            result ('TypeInputBotInlineResult'): The message
            user_id ('TypeInputUser'): The user to whom the [web_app_send_prepared_message event](https://core.telegram.org/api/web-events#web-app-send-prepared-message) event will be sent
            peer_types (Optional[List['TypeInlineQueryPeerType']], optional): Types of chats where this message can be sent
        """

        self.result = result
        self.user_id = user_id
        self.peer_types = peer_types

    def to_bytes(self, boxed: bool=True):
        with Writer(b'/\x7f\x1f\xf2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.result,
                    group_id=0X84BAC7FB
                )
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )

                if flags(self.peer_types, 0):
                    writer.vector(
                        self.peer_types,
                        lambda value: writer.object(
                            value,
                            group_id=0X6AF2CA99
                        )
                    )

            return writer.getvalue()