
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.reaction import TypeReaction
    from ...types.input_peer import TypeInputPeer
    from ...types.messages_filter import TypeMessagesFilter


class Search(TLRequest[TypeMessagesMessages]):
    """
    Search for messages.

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`FromPeerInvalidError: The specified from_id is invalid.
        `400`InputFilterInvalidError: The specified filter is invalid.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PeerIdNotSupportedError: The provided peer ID is not supported.
        `400`SearchQueryEmptyError: The search query is empty.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.

    """

    _id = 0X29EE847A
    _result_id = 0XC8BB9188

    def __init__(
        self,
        peer: 'TypeInputPeer',
        q: str,
        filter: 'TypeMessagesFilter',
        min_date: int,
        max_date: int,
        offset_id: int,
        add_offset: int,
        limit: int,
        max_id: int,
        min_id: int,
        hash: int,
        from_id: Optional['TypeInputPeer'] = None,
        saved_peer_id: Optional['TypeInputPeer'] = None,
        saved_reaction: Optional[List['TypeReaction']] = None,
        top_msg_id: Optional[int] = None
    ):

        """
        Search for messages.

        Args:
            peer ('TypeInputPeer'): User or chat, histories with which are searched, or [(inputPeerEmpty)](https://core.telegram.org/constructor/inputPeerEmpty) constructor to search in all private chats and [normal groups (not channels)](https://core.telegram.org/api/channel). Use [messages.searchGlobal](https://core.telegram.org/method/messages.searchGlobal) to search globally in all chats, groups, supergroups and channels.
            q (str): Text search request
            filter ('TypeMessagesFilter'): Filter to return only specified message types
            min_date (int): If a positive value was transferred, only messages with a sending date bigger than the transferred one will be returned
            max_date (int): If a positive value was transferred, only messages with a sending date smaller than the transferred one will be returned
            offset_id (int): Only return messages starting from the specified message ID
            add_offset (int): [Additional offset](https://core.telegram.org/api/offsets)
            limit (int): [Number of results to return](https://core.telegram.org/api/offsets), can be 0 to only return the message counter.
            max_id (int): [Maximum message ID to return](https://core.telegram.org/api/offsets)
            min_id (int): [Minimum message ID to return](https://core.telegram.org/api/offsets)
            hash (int): [Hash](https://core.telegram.org/api/offsets)
            from_id (Optional['TypeInputPeer'], optional): Only return messages sent by the specified user ID
            saved_peer_id (Optional['TypeInputPeer'], optional): Search within the [saved message dialog](https://core.telegram.org/api/saved-messages) with this ID.
            saved_reaction (Optional[List['TypeReaction']], optional): You may search for [saved messages tagged](https://core.telegram.org/api/saved-messages#tags) with one or more reactions using this flag.
            top_msg_id (Optional[int], optional): [Thread ID](https://core.telegram.org/api/threads)
        """

        self.peer = peer
        self.q = q
        self.filter = filter
        self.min_date = min_date
        self.max_date = max_date
        self.offset_id = offset_id
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.hash = hash
        self.from_id = from_id
        self.saved_peer_id = saved_peer_id
        self.saved_reaction = saved_reaction
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'z\x84\xee)' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.q)

                if flags(self.from_id, 0):
                    writer.object(
                        self.from_id,
                        group_id=0X995DB9DF
                    )

                if flags(self.saved_peer_id, 2):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0X995DB9DF
                    )

                if flags(self.saved_reaction, 3):
                    writer.vector(
                        self.saved_reaction,
                        lambda value: writer.object(
                            value,
                            group_id=0X19F930D1
                        )
                    )

                if flags(self.top_msg_id, 1):
                    writer.int(self.top_msg_id)
                writer.object(
                    self.filter,
                    group_id=0X8CDA33F
                )
                writer.int(self.min_date)
                writer.int(self.max_date)
                writer.int(self.offset_id)
                writer.int(self.add_offset)
                writer.int(self.limit)
                writer.int(self.max_id)
                writer.int(self.min_id)
                writer.long(self.hash)

            return writer.getvalue()