
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.reply_markup import TypeReplyMarkup
    from ...types.input_reply_to import TypeInputReplyTo
    from ...types.message_entity import TypeMessageEntity
    from ...types.suggested_post import TypeSuggestedPost
    from ...types.input_quick_reply_shortcut import TypeInputQuickReplyShortcut


class SendMessage(TLRequest[TypeUpdates]):
    """
    Sends a message to a chat

    **Bots can use this method**

    Raises:
        `400`AdminRightsEmptyError: The chatAdminRights constructor passed in keyboardButtonRequestPeer.peer_type.user_admin_rights has no rights set (i.e. flags is 0).
        `400`BotDomainInvalidError: Bot domain invalid.
        `400`BotInvalidError: This is not a valid bot.
        `400`BusinessPeerInvalidError: Messages can't be set to the specified peer through the current [business connection](https://core.telegram.org/api/business#connected-bots).
        `400`BusinessPeerUsageMissingError: You cannot send a message to a user through a [business connection](https://core.telegram.org/api/business#connected-bots) if the user hasn't recently contacted us.
        `400`ButtonCopyTextInvalidError: The specified [keyboardButtonCopy](https://core.telegram.org/constructor/keyboardButtonCopy).`copy_text` is invalid.
        `400`ButtonDataInvalidError: The data of one or more of the buttons you provided is invalid.
        `400`ButtonIdInvalidError: The specified button ID is invalid.
        `400`ButtonTypeInvalidError: The type of one or more of the buttons you provided is invalid.
        `400`ButtonUrlInvalidError: Button URL invalid.
        `400`ButtonUserInvalidError: The `user_id` passed to inputKeyboardButtonUserProfile is invalid!
        `400`ButtonUserPrivacyRestrictedError: The privacy setting of the user specified in a [inputKeyboardButtonUserProfile](https://core.telegram.org/constructor/inputKeyboardButtonUserProfile) button do not allow creating such a button.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatRestrictedError: You can't send messages in this chat, you were restricted.
        `400`DocumentInvalidError: The specified document is invalid.
        `400`EncryptionDeclinedError: The secret chat was declined.
        `400`EntitiesTooLongError: You provided too many styled message entities.
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`EntityMentionUserInvalidError: You mentioned an invalid user.
        `400`FromMessageBotDisabledError: Bots can't use fromMessage min constructors.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MessageEmptyError: The provided message is empty.
        `400`MessageTooLongError: The provided message is too long.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PinnedDialogsTooMuchError: Too many pinned dialogs.
        `400`PollOptionInvalidError: Invalid poll option provided.
        `400`QuickRepliesTooMuchError: A maximum of [appConfig.`quick_replies_limit`](https://core.telegram.org/api/config#quick-replies-limit) shortcuts may be created, the limit was reached.
        `400`QuoteTextInvalidError: The specified `reply_to`.`quote_text` field is invalid.
        `400`ReplyMarkupInvalidError: The provided reply markup is invalid.
        `400`ReplyMarkupTooLongError: The specified reply_markup is too long.
        `400`ReplyMessagesTooMuchError: Each shortcut can contain a maximum of [appConfig.`quick_reply_messages_limit`](https://core.telegram.org/api/config#quick-reply-messages-limit) messages, the limit was reached.
        `400`ReplyMessageIdInvalidError: The specified reply-to message ID is invalid.
        `400`ReplyToInvalidError: The specified `reply_to` field is invalid.
        `400`ReplyToUserInvalidError: The replied-to user is invalid.
        `400`ScheduleBotNotAllowedError: Bots cannot schedule messages.
        `400`ScheduleDateTooLateError: You can't schedule a message this far in the future.
        `400`ScheduleStatusPrivateError: Can't schedule until user is online, if the user's last seen timestamp is hidden by their privacy settings.
        `400`ScheduleTooMuchError: There are too many scheduled messages.
        `400`SendAsPeerInvalidError: You can't send messages as the specified peer.
        `400`StoryIdInvalidError: The specified story ID is invalid.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`UserIsBotError: Bots can't send messages to other bots.
        `400`WcConvertUrlInvalidError: WC convert URL invalid.
        `400`YouBlockedUserError: You blocked this user.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `406`PaymentUnsupportedError: A detailed description of the error will be received separately as described [here &raquo;](https://core.telegram.org/api/errors#406-not-acceptable).
        `406`PrivacyPremiumRequiredError: You need a [Telegram Premium subscription](https://core.telegram.org/api/premium) to send a message to this user.
        `406`TopicClosedError: This topic was closed, you can't send messages to it anymore.
        `406`TopicDeletedError: The specified topic was deleted.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatGuestSendForbiddenError: You join the discussion group before commenting, see [here &raquo;](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group) for more info.
        `403`ChatSendPlainForbiddenError: You can't send non-media (text) messages in this chat.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.
        `403`UserIsBlockedError: You were blocked by this user.
        `500`MsgWaitFailedError: A waiting call returned an error.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.
        `404`PeerIdInvalidError: The provided peer id is invalid.
        `420`SlowmodeWaitError: Slowmode is enabled in this chat: wait {seconds} seconds before sending another message to this chat.

    """

    _id = 0XFE05DC9A
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        message: str,
        no_webpage: bool = False,
        silent: bool = False,
        background: bool = False,
        clear_draft: bool = False,
        noforwards: bool = False,
        update_stickersets_order: bool = False,
        invert_media: bool = False,
        allow_paid_floodskip: bool = False,
        reply_to: Optional['TypeInputReplyTo'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        schedule_date: Optional[int] = None,
        send_as: Optional['TypeInputPeer'] = None,
        quick_reply_shortcut: Optional['TypeInputQuickReplyShortcut'] = None,
        effect: Optional[int] = None,
        allow_paid_stars: Optional[int] = None,
        suggested_post: Optional['TypeSuggestedPost'] = None,
        random_id: int = None
    ):

        """
        Sends a message to a chat

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): The destination where the message will be sent
            message (str): The message
            no_webpage (bool, optional): Set this flag to disable generation of the webpage preview
            silent (bool, optional): Send this message silently (no notifications for the receivers)
            background (bool, optional): Send this message as background message
            clear_draft (bool, optional): Clear the draft field
            noforwards (bool, optional): Only for bots, disallows forwarding and saving of the messages, even if the destination chat doesn't have [content protection](https://telegram.org/blog/protected-content-delete-by-date-and-more) enabled
            update_stickersets_order (bool, optional): Whether to move used stickersets to top, [see here for more info on this flag](https://core.telegram.org/api/stickers#recent-stickersets)
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            allow_paid_floodskip (bool, optional): Bots only: if set, allows sending up to 1000 messages per second, ignoring [broadcasting limits](https://core.telegram.org/bots/faq#how-can-i-message-all-of-my-bot-39s-subscribers-at-once) for a fee of 0.1 Telegram Stars per message. The relevant Stars will be withdrawn from the bot's balance.
            reply_to (Optional['TypeInputReplyTo'], optional): If set, indicates that the message should be sent in reply to the specified message or story. Also used to quote other messages.
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup for sending bot buttons
            entities (Optional[List['TypeMessageEntity']], optional): Message [entities](https://core.telegram.org/api/entities) for sending styled text
            schedule_date (Optional[int], optional): Scheduled message date for [scheduled messages](https://core.telegram.org/api/scheduled-messages)
            send_as (Optional['TypeInputPeer'], optional): Send this message as the specified peer
            quick_reply_shortcut (Optional['TypeInputQuickReplyShortcut'], optional): Add the message to the specified [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts), instead.
            effect (Optional[int], optional): Specifies a [message effect](https://core.telegram.org/api/effects) to use for the message.
            allow_paid_stars (Optional[int], optional): ...
            suggested_post (Optional['TypeSuggestedPost'], optional): ...
            random_id (int, optional): Unique client message ID required to prevent message resending
        """

        self.peer = peer
        self.message = message
        self.no_webpage = no_webpage
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.noforwards = noforwards
        self.update_stickersets_order = update_stickersets_order
        self.invert_media = invert_media
        self.allow_paid_floodskip = allow_paid_floodskip
        self.reply_to = reply_to
        self.reply_markup = reply_markup
        self.entities = entities
        self.schedule_date = schedule_date
        self.send_as = send_as
        self.quick_reply_shortcut = quick_reply_shortcut
        self.effect = effect
        self.allow_paid_stars = allow_paid_stars
        self.suggested_post = suggested_post
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9a\xdc\x05\xfe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 1)
                flags(self.silent, 5)
                flags(self.background, 6)
                flags(self.clear_draft, 7)
                flags(self.noforwards, 14)
                flags(self.update_stickersets_order, 15)
                flags(self.invert_media, 16)
                flags(self.allow_paid_floodskip, 19)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.reply_to, 0):
                    writer.object(
                        self.reply_to,
                        group_id=0X8EEA0D0F
                    )
                writer.string(self.message)
                writer.long(self.random_id)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

                if flags(self.entities, 3):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.schedule_date, 10):
                    writer.int(self.schedule_date)

                if flags(self.send_as, 13):
                    writer.object(
                        self.send_as,
                        group_id=0X995DB9DF
                    )

                if flags(self.quick_reply_shortcut, 17):
                    writer.object(
                        self.quick_reply_shortcut,
                        group_id=0X60706B98
                    )

                if flags(self.effect, 18):
                    writer.long(self.effect)

                if flags(self.allow_paid_stars, 21):
                    writer.long(self.allow_paid_stars)

                if flags(self.suggested_post, 22):
                    writer.object(
                        self.suggested_post,
                        group_id=0X7DC96856
                    )

            return writer.getvalue()