
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class TogglePinnedToTop(TLRequest[bool]):
    """
    Pin some stories to the top of the profile, see [here](https://core.telegram.org/api/stories#pinned-or-archived-stories) for more info.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StoryIdInvalidError: The specified story ID is invalid.

    """

    _id = 0XB297E9B
    _result_id = 0X43B904E1

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: List[int]
    ):

        """
        Pin some stories to the top of the profile, see [here](https://core.telegram.org/api/stories#pinned-or-archived-stories) for more info.

        Args:
            peer ('TypeInputPeer'): Peer where to pin stories.
            id (List[int]): IDs of the stories to pin (max [stories_pinned_to_top_count_max](https://core.telegram.org/api/config#stories-pinned-to-top-count-max)).
        """

        self.peer = peer
        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9b~)\x0b' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.vector(
                self.id,
                writer.int
            )

            return writer.getvalue()