
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.updates.channel_difference import TypeUpdatesChannelDifference


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel
    from ...types.channel_messages_filter import TypeChannelMessagesFilter


class GetChannelDifference(TLRequest[TypeUpdatesChannelDifference]):
    """
    Returns the difference between the current state of updates of a certain channel and transmitted.

    **Bots can use this method**

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`FromMessageBotDisabledError: Bots can't use fromMessage min constructors.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PersistentTimestampEmptyError: Persistent timestamp empty.
        `400`PersistentTimestampInvalidError: Persistent timestamp invalid.
        `400`PinnedDialogsTooMuchError: Too many pinned dialogs.
        `400`RangesInvalidError: Invalid range provided.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `403`ChannelPublicGroupNaError: channel/supergroup not available.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `500`PersistentTimestampOutdatedError: Channel internal replication issues, try again later (treat this like an RPC_CALL_FAIL).

    """

    _id = 0X3173D78
    _result_id = 0X93944747

    def __init__(
        self,
        channel: 'TypeInputChannel',
        filter: 'TypeChannelMessagesFilter',
        pts: int,
        limit: int,
        force: bool = False
    ):

        """
        Returns the difference between the current state of updates of a certain channel and transmitted.

        **Bots can use this method**

        Args:
            channel ('TypeInputChannel'): The channel
            filter ('TypeChannelMessagesFilter'): Messsage filter
            pts (int): Persistent timestamp (see [updates](https://core.telegram.org/api/updates))
            limit (int): How many updates to fetch, max 100000 Ordinary (non-bot) users are supposed to pass 10-100
            force (bool, optional): Set to true to skip some possibly unneeded updates and reduce server-side load
        """

        self.channel = channel
        self.filter = filter
        self.pts = pts
        self.limit = limit
        self.force = force

    def to_bytes(self, boxed: bool=True):
        with Writer(b'x=\x17\x03' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.force, 0)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.object(
                    self.filter,
                    group_id=0X5833A075
                )
                writer.int(self.pts)
                writer.int(self.limit)

            return writer.getvalue()