
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class Boost(TLObject, family='TypeBoost'):
    """
    Info about one or more [boosts](https://core.telegram.org/api/boost) applied by a specific user.
    """

    _id = 0X4B3E14D6
    _group_id = 0X9F7E3FDC

    def __init__(
        self,
        id: str,
        date: int,
        expires: int,
        gift: bool = False,
        giveaway: bool = False,
        unclaimed: bool = False,
        user_id: Optional[int] = None,
        giveaway_msg_id: Optional[int] = None,
        used_gift_slug: Optional[str] = None,
        multiplier: Optional[int] = None,
        stars: Optional[int] = None
    ):

        """
        Info about one or more [boosts](https://core.telegram.org/api/boost) applied by a specific user.

        Args:
            id (str): Unique ID for this set of boosts.
            date (int): When was the boost applied
            expires (int): When does the boost expire
            gift (bool, optional): Whether this boost was applied because the channel/supergroup [directly gifted a subscription to the user](https://core.telegram.org/api/giveaways).
            giveaway (bool, optional): Whether this boost was applied because the user was chosen in a [giveaway started by the channel/supergroup](https://core.telegram.org/api/giveaways).
            unclaimed (bool, optional): If set, the user hasn't yet invoked [payments.applyGiftCode](https://core.telegram.org/method/payments.applyGiftCode) to claim a subscription gifted [directly or in a giveaway by the channel](https://core.telegram.org/api/giveaways).
            user_id (Optional[int], optional): ID of the user that applied the boost.
            giveaway_msg_id (Optional[int], optional): The message ID of the [giveaway](https://core.telegram.org/api/giveaways)
            used_gift_slug (Optional[str], optional): The created Telegram Premium gift code, only set if either gift or giveaway are set AND it is either a gift code for the currently logged in user or if it was already claimed.
            multiplier (Optional[int], optional): If set, this boost counts as multiplier boosts, otherwise it counts as a single boost.
            stars (Optional[int], optional): Number of Telegram Stars distributed among the winners of the giveaway.
        """

        self.id = id
        self.date = date
        self.expires = expires
        self.gift = gift
        self.giveaway = giveaway
        self.unclaimed = unclaimed
        self.user_id = user_id
        self.giveaway_msg_id = giveaway_msg_id
        self.used_gift_slug = used_gift_slug
        self.multiplier = multiplier
        self.stars = stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\x14>K' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.gift, 1)
                flags(self.giveaway, 2)
                flags(self.unclaimed, 3)
                writer.string(self.id)

                if flags(self.user_id, 0):
                    writer.long(self.user_id)

                if flags(self.giveaway_msg_id, 2):
                    writer.int(self.giveaway_msg_id)
                writer.int(self.date)
                writer.int(self.expires)

                if flags(self.used_gift_slug, 4):
                    writer.string(self.used_gift_slug)

                if flags(self.multiplier, 5):
                    writer.int(self.multiplier)

                if flags(self.stars, 6):
                    writer.long(self.stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        user_id_ = (
            reader.long()
            if flags(0) else None
        )

        giveaway_msg_id_ = (
            reader.int()
            if flags(2) else None
        )

        date_ = reader.int()
        expires_ = reader.int()
        used_gift_slug_ = (
            reader.string()
            if flags(4) else None
        )

        multiplier_ = (
            reader.int()
            if flags(5) else None
        )

        stars_ = (
            reader.long()
            if flags(6) else None
        )

        return cls(
            id=id_,
            date=date_,
            expires=expires_,
            gift=flags(1),
            giveaway=flags(2),
            unclaimed=flags(3),
            user_id=user_id_,
            giveaway_msg_id=giveaway_msg_id_,
            used_gift_slug=used_gift_slug_,
            multiplier=multiplier_,
            stars=stars_
        )

TypeBoost = Boost