
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .document import TypeDocument
    from ...gadgets.byteutils import Reader


class BotAppNotModified(TLObject, family='TypeBotApp'):
    """
    Bot app info hasn't changed.
    """

    _id = 0X5DA674B7
    _group_id = 0XC9665A15


    def to_bytes(self, boxed: bool=True):
        return b'\xb7t\xa6]' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class BotApp(TLObject, family='TypeBotApp'):
    """
    Contains information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps).
    """

    _id = 0X95FCD1D6
    _group_id = 0XC9665A15

    def __init__(
        self,
        id: int,
        access_hash: int,
        short_name: str,
        title: str,
        description: str,
        photo: 'TypePhoto',
        hash: int,
        document: Optional['TypeDocument'] = None
    ):

        """
        Contains information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps).

        Args:
            id (int): bot mini app ID
            access_hash (int): bot mini app access hash
            short_name (str): bot mini app short name, used to generate [Direct Mini App deep links](https://core.telegram.org/api/links#direct-mini-app-links).
            title (str): bot mini app title.
            description (str): bot mini app description.
            photo ('TypePhoto'): bot mini app photo.
            hash (int): Hash to pass to [messages.getBotApp](https://core.telegram.org/method/messages.getBotApp), to avoid refetching bot app info if it hasn't changed.
            document (Optional['TypeDocument'], optional): bot mini app animation.
        """

        self.id = id
        self.access_hash = access_hash
        self.short_name = short_name
        self.title = title
        self.description = description
        self.photo = photo
        self.hash = hash
        self.document = document

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\xd1\xfc\x95' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.string(self.short_name)
                writer.string(self.title)
                writer.string(self.description)
                writer.object(
                    self.photo,
                    group_id=0XDDAD9CAC
                )

                if flags(self.document, 0):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )
                writer.long(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        short_name_ = reader.string()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(0) else None
        )

        hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_,
            short_name=short_name_,
            title=title_,
            description=description_,
            photo=photo_,
            hash=hash_,
            document=document_
        )

TypeBotApp = Union[
    BotAppNotModified,
    BotApp
]