
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .username import TypeUsername
    from .chat_photo import TypeChatPhoto
    from .peer_color import TypePeerColor
    from .emoji_status import TypeEmojiStatus
    from .input_channel import TypeInputChannel
    from .chat_admin_rights import TypeChatAdminRights
    from .chat_banned_rights import TypeChatBannedRights
    from .restriction_reason import TypeRestrictionReason
    from ...gadgets.byteutils import Reader


class ChatEmpty(TLObject, family='TypeChat'):
    """
    Empty constructor, group doesn't exist
    """

    _id = 0X29562865
    _group_id = 0X73A5C0D9

    def __init__(
        self,
        id: int
    ):

        """
        Empty constructor, group doesn't exist

        Args:
            id (int): Group identifier
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'e(V)' if boxed else b'') as writer:
            writer.long(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()

        return cls(
            id=id_
        )

class Chat(TLObject, family='TypeChat'):
    """
    Info about a group.
    """

    _id = 0X41CBF256
    _group_id = 0X73A5C0D9

    def __init__(
        self,
        id: int,
        title: str,
        photo: 'TypeChatPhoto',
        participants_count: int,
        date: int,
        version: int,
        creator: bool = False,
        left: bool = False,
        deactivated: bool = False,
        call_active: bool = False,
        call_not_empty: bool = False,
        noforwards: bool = False,
        migrated_to: Optional['TypeInputChannel'] = None,
        admin_rights: Optional['TypeChatAdminRights'] = None,
        default_banned_rights: Optional['TypeChatBannedRights'] = None
    ):

        """
        Info about a group.

        Args:
            id (int): ID of the group, see [here](https://core.telegram.org/api/peers#peer-id) for more info
            title (str): Title
            photo ('TypeChatPhoto'): Chat photo
            participants_count (int): Participant count
            date (int): Date of creation of the group
            version (int): Used in basic groups to reorder updates and make sure that all of them were received.
            creator (bool, optional): Whether the current user is the creator of the group
            left (bool, optional): Whether the current user has left the group
            deactivated (bool, optional): Whether the group was [migrated](https://core.telegram.org/api/channel)
            call_active (bool, optional): Whether a group call is currently active
            call_not_empty (bool, optional): Whether there's anyone in the group call
            noforwards (bool, optional): Whether this group is [protected](https://telegram.org/blog/protected-content-delete-by-date-and-more), thus does not allow forwarding messages from it
            migrated_to (Optional['TypeInputChannel'], optional): Means this chat was [upgraded](https://core.telegram.org/api/channel) to a supergroup
            admin_rights (Optional['TypeChatAdminRights'], optional): [Admin rights](https://core.telegram.org/api/rights) of the user in the group
            default_banned_rights (Optional['TypeChatBannedRights'], optional): [Default banned rights](https://core.telegram.org/api/rights) of all users in the group
        """

        self.id = id
        self.title = title
        self.photo = photo
        self.participants_count = participants_count
        self.date = date
        self.version = version
        self.creator = creator
        self.left = left
        self.deactivated = deactivated
        self.call_active = call_active
        self.call_not_empty = call_not_empty
        self.noforwards = noforwards
        self.migrated_to = migrated_to
        self.admin_rights = admin_rights
        self.default_banned_rights = default_banned_rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'V\xf2\xcbA' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.creator, 0)
                flags(self.left, 2)
                flags(self.deactivated, 5)
                flags(self.call_active, 23)
                flags(self.call_not_empty, 24)
                flags(self.noforwards, 25)
                writer.long(self.id)
                writer.string(self.title)
                writer.object(
                    self.photo,
                    group_id=0XFC7FED8C
                )
                writer.int(self.participants_count)
                writer.int(self.date)
                writer.int(self.version)

                if flags(self.migrated_to, 6):
                    writer.object(
                        self.migrated_to,
                        group_id=0X42691CEF
                    )

                if flags(self.admin_rights, 14):
                    writer.object(
                        self.admin_rights,
                        group_id=0X2A03C5CB
                    )

                if flags(self.default_banned_rights, 18):
                    writer.object(
                        self.default_banned_rights,
                        group_id=0XDB47663A
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        title_ = reader.string()
        photo_ = reader.object(
            group_id=0XFC7FED8C
        )

        participants_count_ = reader.int()
        date_ = reader.int()
        version_ = reader.int()
        migrated_to_ = (
            reader.object(
                group_id=0X42691CEF
            )
            if flags(6) else None
        )

        admin_rights_ = (
            reader.object(
                group_id=0X2A03C5CB
            )
            if flags(14) else None
        )

        default_banned_rights_ = (
            reader.object(
                group_id=0XDB47663A
            )
            if flags(18) else None
        )

        return cls(
            id=id_,
            title=title_,
            photo=photo_,
            participants_count=participants_count_,
            date=date_,
            version=version_,
            creator=flags(0),
            left=flags(2),
            deactivated=flags(5),
            call_active=flags(23),
            call_not_empty=flags(24),
            noforwards=flags(25),
            migrated_to=migrated_to_,
            admin_rights=admin_rights_,
            default_banned_rights=default_banned_rights_
        )

class ChatForbidden(TLObject, family='TypeChat'):
    """
    A group to which the user has no access. E.g., because the user was kicked from the group.
    """

    _id = 0X6592A1A7
    _group_id = 0X73A5C0D9

    def __init__(
        self,
        id: int,
        title: str
    ):

        """
        A group to which the user has no access. E.g., because the user was kicked from the group.

        Args:
            id (int): User identifier
            title (str): Group name
        """

        self.id = id
        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7\xa1\x92e' if boxed else b'') as writer:
            writer.long(self.id)
            writer.string(self.title)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        title_ = reader.string()

        return cls(
            id=id_,
            title=title_
        )

class Channel(TLObject, family='TypeChat'):
    """
    Channel/supergroup info
    """

    _id = 0XFE685355
    _group_id = 0X73A5C0D9

    def __init__(
        self,
        id: int,
        title: str,
        photo: 'TypeChatPhoto',
        date: int,
        creator: bool = False,
        left: bool = False,
        broadcast: bool = False,
        verified: bool = False,
        megagroup: bool = False,
        restricted: bool = False,
        signatures: bool = False,
        min: bool = False,
        scam: bool = False,
        has_link: bool = False,
        has_geo: bool = False,
        slowmode_enabled: bool = False,
        call_active: bool = False,
        call_not_empty: bool = False,
        fake: bool = False,
        gigagroup: bool = False,
        noforwards: bool = False,
        join_to_send: bool = False,
        join_request: bool = False,
        forum: bool = False,
        stories_hidden: bool = False,
        stories_hidden_min: bool = False,
        stories_unavailable: bool = False,
        signature_profiles: bool = False,
        autotranslation: bool = False,
        broadcast_messages_allowed: bool = False,
        monoforum: bool = False,
        forum_tabs: bool = False,
        access_hash: Optional[int] = None,
        username: Optional[str] = None,
        restriction_reason: Optional[List['TypeRestrictionReason']] = None,
        admin_rights: Optional['TypeChatAdminRights'] = None,
        banned_rights: Optional['TypeChatBannedRights'] = None,
        default_banned_rights: Optional['TypeChatBannedRights'] = None,
        participants_count: Optional[int] = None,
        usernames: Optional[List['TypeUsername']] = None,
        stories_max_id: Optional[int] = None,
        color: Optional['TypePeerColor'] = None,
        profile_color: Optional['TypePeerColor'] = None,
        emoji_status: Optional['TypeEmojiStatus'] = None,
        level: Optional[int] = None,
        subscription_until_date: Optional[int] = None,
        bot_verification_icon: Optional[int] = None,
        send_paid_messages_stars: Optional[int] = None,
        linked_monoforum_id: Optional[int] = None
    ):

        """
        Channel/supergroup info

        Args:
            id (int): ID of the channel, see [here](https://core.telegram.org/api/peers#peer-id) for more info
            title (str): Title
            photo ('TypeChatPhoto'): Profile photo
            date (int): Date when the user joined the supergroup/channel, or if the user isn't a member, its creation date
            creator (bool, optional): Whether the current user is the creator of this channel
            left (bool, optional): Whether the current user has left or is not a member of this channel
            broadcast (bool, optional): Is this a channel?
            verified (bool, optional): Is this channel verified by telegram?
            megagroup (bool, optional): Is this a supergroup? Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            restricted (bool, optional): Whether viewing/writing in this channel for a reason (see restriction_reason)
            signatures (bool, optional): Whether signatures are enabled (channels)
            min (bool, optional): See [min](https://core.telegram.org/api/min)
            scam (bool, optional): This channel/supergroup is probably a scam Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            has_link (bool, optional): Whether this channel has a linked [discussion group](https://core.telegram.org/api/discussion) (or this supergroup is a channel's discussion group). The actual ID of the linked channel/supergroup is contained in [channelFull](https://core.telegram.org/constructor/channelFull). linked_chat_id. Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            has_geo (bool, optional): Whether this chanel has a geoposition
            slowmode_enabled (bool, optional): Whether slow mode is enabled for groups to prevent flood in chat. Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            call_active (bool, optional): Whether a group call or livestream is currently active
            call_not_empty (bool, optional): Whether there's anyone in the group call or livestream
            fake (bool, optional): If set, this [supergroup/channel](https://core.telegram.org/api/channel) was reported by many users as a fake or scam: be careful when interacting with it. Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            gigagroup (bool, optional): Whether this [supergroup](https://core.telegram.org/api/channel) is a gigagroup Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            noforwards (bool, optional): Whether this channel or group is [protected](https://telegram.org/blog/protected-content-delete-by-date-and-more), thus does not allow forwarding messages from it
            join_to_send (bool, optional): Whether a user needs to join the supergroup before they can send messages: can be false only for [discussion groups](https://core.telegram.org/api/discussion), toggle using [channels.toggleJoinToSend](https://core.telegram.org/method/channels.toggleJoinToSend) Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            join_request (bool, optional): Whether a user's join request will have to be [approved by administrators](https://core.telegram.org/api/invites#join-requests), toggle using [channels.toggleJoinToSend](https://core.telegram.org/method/channels.toggleJoinRequest) Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            forum (bool, optional): Whether this supergroup is a [forum](https://core.telegram.org/api/forum). Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            stories_hidden (bool, optional): Whether we have [hidden all stories posted by this channel](https://core.telegram.org/api/stories#hiding-stories-of-other-users).
            stories_hidden_min (bool, optional): If set, indicates that the stories_hidden flag was not populated, and its value must cannot be relied on; use the previously cached value, or re-fetch the constructor using [channels.getChannels](https://core.telegram.org/method/channels.getChannels) to obtain the latest value of the stories_hidden flag.
            stories_unavailable (bool, optional): No stories from the channel are visible.
            signature_profiles (bool, optional): If set, messages sent by admins to this channel will link to the admin's profile (just like with groups).
            autotranslation (bool, optional): ...
            broadcast_messages_allowed (bool, optional): ...
            monoforum (bool, optional): ...
            forum_tabs (bool, optional): ...
            access_hash (Optional[int], optional): Access hash, see [here](https://core.telegram.org/api/peers#access-hash) for more info
            username (Optional[str], optional): Main active username.
            restriction_reason (Optional[List['TypeRestrictionReason']], optional): Contains the reason why access to this channel must be restricted. Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            admin_rights (Optional['TypeChatAdminRights'], optional): Admin rights of the user in this channel (see [rights](https://core.telegram.org/api/rights))
            banned_rights (Optional['TypeChatBannedRights'], optional): Banned rights of the user in this channel (see [rights](https://core.telegram.org/api/rights))
            default_banned_rights (Optional['TypeChatBannedRights'], optional): Default chat rights (see [rights](https://core.telegram.org/api/rights))
            participants_count (Optional[int], optional): Participant count
            usernames (Optional[List['TypeUsername']], optional): Additional usernames
            stories_max_id (Optional[int], optional): ID of the maximum read [story](https://core.telegram.org/api/stories).
            color (Optional['TypePeerColor'], optional): The channel's [accent color](https://core.telegram.org/api/colors).
            profile_color (Optional['TypePeerColor'], optional): The channel's [profile color](https://core.telegram.org/api/colors).
            emoji_status (Optional['TypeEmojiStatus'], optional): [Emoji status](https://core.telegram.org/api/emoji-status)
            level (Optional[int], optional): [Boost level](https://core.telegram.org/api/boost). Changes to this flag should invalidate the local [channelFull](https://core.telegram.org/constructor/channelFull) cache for this channel/supergroup ID, see [here](https://core.telegram.org/api/peers#full-info-database) for more info.
            subscription_until_date (Optional[int], optional): Expiration date of the [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions) the current user has bought to gain access to this channel.
            bot_verification_icon (Optional[int], optional): ...
            send_paid_messages_stars (Optional[int], optional): ...
            linked_monoforum_id (Optional[int], optional): ...
        """

        self.id = id
        self.title = title
        self.photo = photo
        self.date = date
        self.creator = creator
        self.left = left
        self.broadcast = broadcast
        self.verified = verified
        self.megagroup = megagroup
        self.restricted = restricted
        self.signatures = signatures
        self.min = min
        self.scam = scam
        self.has_link = has_link
        self.has_geo = has_geo
        self.slowmode_enabled = slowmode_enabled
        self.call_active = call_active
        self.call_not_empty = call_not_empty
        self.fake = fake
        self.gigagroup = gigagroup
        self.noforwards = noforwards
        self.join_to_send = join_to_send
        self.join_request = join_request
        self.forum = forum
        self.stories_hidden = stories_hidden
        self.stories_hidden_min = stories_hidden_min
        self.stories_unavailable = stories_unavailable
        self.signature_profiles = signature_profiles
        self.autotranslation = autotranslation
        self.broadcast_messages_allowed = broadcast_messages_allowed
        self.monoforum = monoforum
        self.forum_tabs = forum_tabs
        self.access_hash = access_hash
        self.username = username
        self.restriction_reason = restriction_reason
        self.admin_rights = admin_rights
        self.banned_rights = banned_rights
        self.default_banned_rights = default_banned_rights
        self.participants_count = participants_count
        self.usernames = usernames
        self.stories_max_id = stories_max_id
        self.color = color
        self.profile_color = profile_color
        self.emoji_status = emoji_status
        self.level = level
        self.subscription_until_date = subscription_until_date
        self.bot_verification_icon = bot_verification_icon
        self.send_paid_messages_stars = send_paid_messages_stars
        self.linked_monoforum_id = linked_monoforum_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'USh\xfe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.creator, 0)
                flags(self.left, 2)
                flags(self.broadcast, 5)
                flags(self.verified, 7)
                flags(self.megagroup, 8)
                flags(self.restricted, 9)
                flags(self.signatures, 11)
                flags(self.min, 12)
                flags(self.scam, 19)
                flags(self.has_link, 20)
                flags(self.has_geo, 21)
                flags(self.slowmode_enabled, 22)
                flags(self.call_active, 23)
                flags(self.call_not_empty, 24)
                flags(self.fake, 25)
                flags(self.gigagroup, 26)
                flags(self.noforwards, 27)
                flags(self.join_to_send, 28)
                flags(self.join_request, 29)
                flags(self.forum, 30)

                with writer.flag() as flags2:
                    flags2(self.stories_hidden, 1)
                    flags2(self.stories_hidden_min, 2)
                    flags2(self.stories_unavailable, 3)
                    flags2(self.signature_profiles, 12)
                    flags2(self.autotranslation, 15)
                    flags2(self.broadcast_messages_allowed, 16)
                    flags2(self.monoforum, 17)
                    flags2(self.forum_tabs, 19)
                    writer.long(self.id)

                    if flags(self.access_hash, 13):
                        writer.long(self.access_hash)
                    writer.string(self.title)

                    if flags(self.username, 6):
                        writer.string(self.username)
                    writer.object(
                        self.photo,
                        group_id=0XFC7FED8C
                    )
                    writer.int(self.date)

                    if flags(self.restriction_reason, 9):
                        writer.vector(
                            self.restriction_reason,
                            lambda value: writer.object(
                                value,
                                group_id=0X6F3B4470
                            )
                        )

                    if flags(self.admin_rights, 14):
                        writer.object(
                            self.admin_rights,
                            group_id=0X2A03C5CB
                        )

                    if flags(self.banned_rights, 15):
                        writer.object(
                            self.banned_rights,
                            group_id=0XDB47663A
                        )

                    if flags(self.default_banned_rights, 18):
                        writer.object(
                            self.default_banned_rights,
                            group_id=0XDB47663A
                        )

                    if flags(self.participants_count, 17):
                        writer.int(self.participants_count)

                    if flags2(self.usernames, 0):
                        writer.vector(
                            self.usernames,
                            lambda value: writer.object(
                                value,
                                group_id=0X45703151
                            )
                        )

                    if flags2(self.stories_max_id, 4):
                        writer.int(self.stories_max_id)

                    if flags2(self.color, 7):
                        writer.object(
                            self.color,
                            group_id=0XA2C08D16
                        )

                    if flags2(self.profile_color, 8):
                        writer.object(
                            self.profile_color,
                            group_id=0XA2C08D16
                        )

                    if flags2(self.emoji_status, 9):
                        writer.object(
                            self.emoji_status,
                            group_id=0XFBDA9FB
                        )

                    if flags2(self.level, 10):
                        writer.int(self.level)

                    if flags2(self.subscription_until_date, 11):
                        writer.int(self.subscription_until_date)

                    if flags2(self.bot_verification_icon, 13):
                        writer.long(self.bot_verification_icon)

                    if flags2(self.send_paid_messages_stars, 14):
                        writer.long(self.send_paid_messages_stars)

                    if flags2(self.linked_monoforum_id, 18):
                        writer.long(self.linked_monoforum_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        flags2 = reader.flag()
        id_ = reader.long()
        access_hash_ = (
            reader.long()
            if flags(13) else None
        )

        title_ = reader.string()
        username_ = (
            reader.string()
            if flags(6) else None
        )

        photo_ = reader.object(
            group_id=0XFC7FED8C
        )

        date_ = reader.int()
        restriction_reason_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6F3B4470
                )
            )
            if flags(9) else None
        )

        admin_rights_ = (
            reader.object(
                group_id=0X2A03C5CB
            )
            if flags(14) else None
        )

        banned_rights_ = (
            reader.object(
                group_id=0XDB47663A
            )
            if flags(15) else None
        )

        default_banned_rights_ = (
            reader.object(
                group_id=0XDB47663A
            )
            if flags(18) else None
        )

        participants_count_ = (
            reader.int()
            if flags(17) else None
        )

        usernames_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X45703151
                )
            )
            if flags2(0) else None
        )

        stories_max_id_ = (
            reader.int()
            if flags2(4) else None
        )

        color_ = (
            reader.object(
                group_id=0XA2C08D16
            )
            if flags2(7) else None
        )

        profile_color_ = (
            reader.object(
                group_id=0XA2C08D16
            )
            if flags2(8) else None
        )

        emoji_status_ = (
            reader.object(
                group_id=0XFBDA9FB
            )
            if flags2(9) else None
        )

        level_ = (
            reader.int()
            if flags2(10) else None
        )

        subscription_until_date_ = (
            reader.int()
            if flags2(11) else None
        )

        bot_verification_icon_ = (
            reader.long()
            if flags2(13) else None
        )

        send_paid_messages_stars_ = (
            reader.long()
            if flags2(14) else None
        )

        linked_monoforum_id_ = (
            reader.long()
            if flags2(18) else None
        )

        return cls(
            id=id_,
            title=title_,
            photo=photo_,
            date=date_,
            creator=flags(0),
            left=flags(2),
            broadcast=flags(5),
            verified=flags(7),
            megagroup=flags(8),
            restricted=flags(9),
            signatures=flags(11),
            min=flags(12),
            scam=flags(19),
            has_link=flags(20),
            has_geo=flags(21),
            slowmode_enabled=flags(22),
            call_active=flags(23),
            call_not_empty=flags(24),
            fake=flags(25),
            gigagroup=flags(26),
            noforwards=flags(27),
            join_to_send=flags(28),
            join_request=flags(29),
            forum=flags(30),
            stories_hidden=flags2(1),
            stories_hidden_min=flags2(2),
            stories_unavailable=flags2(3),
            signature_profiles=flags2(12),
            autotranslation=flags2(15),
            broadcast_messages_allowed=flags2(16),
            monoforum=flags2(17),
            forum_tabs=flags2(19),
            access_hash=access_hash_,
            username=username_,
            restriction_reason=restriction_reason_,
            admin_rights=admin_rights_,
            banned_rights=banned_rights_,
            default_banned_rights=default_banned_rights_,
            participants_count=participants_count_,
            usernames=usernames_,
            stories_max_id=stories_max_id_,
            color=color_,
            profile_color=profile_color_,
            emoji_status=emoji_status_,
            level=level_,
            subscription_until_date=subscription_until_date_,
            bot_verification_icon=bot_verification_icon_,
            send_paid_messages_stars=send_paid_messages_stars_,
            linked_monoforum_id=linked_monoforum_id_
        )

class ChannelForbidden(TLObject, family='TypeChat'):
    """
    Indicates a channel/supergroup we can't access because we were banned, or for some other reason.
    """

    _id = 0X17D493D5
    _group_id = 0X73A5C0D9

    def __init__(
        self,
        id: int,
        access_hash: int,
        title: str,
        broadcast: bool = False,
        megagroup: bool = False,
        until_date: Optional[int] = None
    ):

        """
        Indicates a channel/supergroup we can't access because we were banned, or for some other reason.

        Args:
            id (int): Channel ID
            access_hash (int): Access hash
            title (str): Title
            broadcast (bool, optional): Is this a channel
            megagroup (bool, optional): Is this a supergroup
            until_date (Optional[int], optional): The ban is valid until the specified date
        """

        self.id = id
        self.access_hash = access_hash
        self.title = title
        self.broadcast = broadcast
        self.megagroup = megagroup
        self.until_date = until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd5\x93\xd4\x17' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.broadcast, 5)
                flags(self.megagroup, 8)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.string(self.title)

                if flags(self.until_date, 16):
                    writer.int(self.until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        title_ = reader.string()
        until_date_ = (
            reader.int()
            if flags(16) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            title=title_,
            broadcast=flags(5),
            megagroup=flags(8),
            until_date=until_date_
        )

TypeChat = Union[
    ChatEmpty,
    Chat,
    ChatForbidden,
    Channel,
    ChannelForbidden
]