
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class CodeSettings(TLObject, family='TypeCodeSettings'):
    """
    Settings used by telegram servers for sending the confirm code.
    """

    _id = 0XAD253D78
    _group_id = 0X4A76A298

    def __init__(
        self,
        allow_flashcall: bool = False,
        current_number: bool = False,
        allow_app_hash: bool = False,
        allow_missed_call: bool = False,
        allow_firebase: bool = False,
        unknown_number: bool = False,
        logout_tokens: Optional[List[bytes]] = None,
        token: Optional[str] = None,
        app_sandbox: bool = False
    ):

        """
        Settings used by telegram servers for sending the confirm code.

        Args:
            allow_flashcall (bool, optional): Whether to allow phone verification via [phone calls](https://core.telegram.org/api/auth).
            current_number (bool, optional): Pass true if the phone number is used on the current device. Ignored if allow_flashcall is not set.
            allow_app_hash (bool, optional): If a token that will be included in eventually sent SMSs is required: required in newer versions of android, to use the [android SMS receiver APIs](https://developers.google.com/identity/sms-retriever/overview)
            allow_missed_call (bool, optional): Whether this device supports receiving the code using the [auth.codeTypeMissedCall](https://core.telegram.org/constructor/auth.codeTypeMissedCall) method
            allow_firebase (bool, optional): Whether Firebase auth is supported
            unknown_number (bool, optional): Set this flag if there is a SIM card in the current device, but it is not possible to check whether the specified phone number matches the SIM's phone number.
            logout_tokens (Optional[List[bytes]], optional): Previously stored future auth tokens, see [the documentation for more info](https://core.telegram.org/api/auth#future-auth-tokens)
            token (Optional[str], optional): Used only by official iOS apps for Firebase auth: device token for apple push.
            app_sandbox (bool, optional): Used only by official iOS apps for firebase auth: whether a sandbox-certificate will be used during transmission of the push notification.
        """

        self.allow_flashcall = allow_flashcall
        self.current_number = current_number
        self.allow_app_hash = allow_app_hash
        self.allow_missed_call = allow_missed_call
        self.allow_firebase = allow_firebase
        self.unknown_number = unknown_number
        self.logout_tokens = logout_tokens
        self.token = token
        self.app_sandbox = app_sandbox

    def to_bytes(self, boxed: bool=True):
        with Writer(b'x=%\xad' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.allow_flashcall, 0)
                flags(self.current_number, 1)
                flags(self.allow_app_hash, 4)
                flags(self.allow_missed_call, 5)
                flags(self.allow_firebase, 7)
                flags(self.unknown_number, 9)

                if flags(self.logout_tokens, 6):
                    writer.vector(
                        self.logout_tokens,
                        writer.bytes
                    )

                if flags(self.token, 8):
                    writer.string(self.token)

                if flags(self.app_sandbox, 8):
                    writer.object(
                        self.app_sandbox,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        logout_tokens_ = (
            reader.vector(
                reader.bytes
            )
            if flags(6) else None
        )

        token_ = (
            reader.string()
            if flags(8) else None
        )

        app_sandbox_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(8) else None
        )

        return cls(
            allow_flashcall=flags(0),
            current_number=flags(1),
            allow_app_hash=flags(4),
            allow_missed_call=flags(5),
            allow_firebase=flags(7),
            unknown_number=flags(9),
            logout_tokens=logout_tokens_,
            token=token_,
            app_sandbox=app_sandbox_
        )

TypeCodeSettings = CodeSettings