
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ConnectedBotStarRef(TLObject, family='TypeConnectedBotStarRef'):
    """
    Info about an [active affiliate program we have with a Mini App](https://core.telegram.org/api/bots/referrals#becoming-an-affiliate)
    """

    _id = 0X19A13F71
    _group_id = 0X6510BF0A

    def __init__(
        self,
        url: str,
        date: int,
        bot_id: int,
        commission_permille: int,
        participants: int,
        revenue: int,
        revoked: bool = False,
        duration_months: Optional[int] = None
    ):

        """
        Info about an [active affiliate program we have with a Mini App](https://core.telegram.org/api/bots/referrals#becoming-an-affiliate)

        Args:
            url (str): [Referral link](https://core.telegram.org/api/links#referral-links) to be shared
            date (int): When did we affiliate with bot_id
            bot_id (int): ID of the mini app that created the affiliate program
            commission_permille (int): The number of Telegram Stars received by the affiliate for each 1000 Telegram Stars received by bot_id
            participants (int): The number of users that used the affiliate program
            revenue (int): The number of Telegram Stars that were earned by the affiliate program
            revoked (bool, optional): If set, this affiliation was revoked by the affiliate using [payments.editConnectedStarRefBot](https://core.telegram.org/method/payments.editConnectedStarRefBot), or by the affiliation program owner using [bots.updateStarRefProgram](https://core.telegram.org/method/bots.updateStarRefProgram)
            duration_months (Optional[int], optional): Number of months the program will be active; if not set, there is no expiration date.
        """

        self.url = url
        self.date = date
        self.bot_id = bot_id
        self.commission_permille = commission_permille
        self.participants = participants
        self.revenue = revenue
        self.revoked = revoked
        self.duration_months = duration_months

    def to_bytes(self, boxed: bool=True):
        with Writer(b'q?\xa1\x19' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.revoked, 1)
                writer.string(self.url)
                writer.int(self.date)
                writer.long(self.bot_id)
                writer.int(self.commission_permille)

                if flags(self.duration_months, 0):
                    writer.int(self.duration_months)
                writer.long(self.participants)
                writer.long(self.revenue)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = reader.string()
        date_ = reader.int()
        bot_id_ = reader.long()
        commission_permille_ = reader.int()
        duration_months_ = (
            reader.int()
            if flags(0) else None
        )

        participants_ = reader.long()
        revenue_ = reader.long()

        return cls(
            url=url_,
            date=date_,
            bot_id=bot_id_,
            commission_permille=commission_permille_,
            participants=participants_,
            revenue=revenue_,
            revoked=flags(1),
            duration_months=duration_months_
        )

TypeConnectedBotStarRef = ConnectedBotStarRef