
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo_size import TypePhotoSize
    from .video_size import TypeVideoSize
    from .document_attribute import TypeDocumentAttribute
    from ...gadgets.byteutils import Reader


class DocumentEmpty(TLObject, family='TypeDocument'):
    """
    Empty constructor, document doesn't exist.
    """

    _id = 0X36F8C871
    _group_id = 0X6547BD50

    def __init__(
        self,
        id: int
    ):

        """
        Empty constructor, document doesn't exist.

        Args:
            id (int): Document ID or 0
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'q\xc8\xf86' if boxed else b'') as writer:
            writer.long(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()

        return cls(
            id=id_
        )

class Document(TLObject, family='TypeDocument'):
    """
    Document
    """

    _id = 0X8FD4C4D8
    _group_id = 0X6547BD50

    def __init__(
        self,
        id: int,
        access_hash: int,
        file_reference: bytes,
        date: int,
        mime_type: str,
        size: int,
        dc_id: int,
        attributes: List['TypeDocumentAttribute'],
        thumbs: Optional[List['TypePhotoSize']] = None,
        video_thumbs: Optional[List['TypeVideoSize']] = None
    ):

        """
        Document

        Args:
            id (int): Document ID
            access_hash (int): Check sum, dependent on document ID
            file_reference (bytes): [File reference](https://core.telegram.org/api/file_reference)
            date (int): Creation date
            mime_type (str): MIME type
            size (int): Size
            dc_id (int): DC ID
            attributes (List['TypeDocumentAttribute']): Attributes
            thumbs (Optional[List['TypePhotoSize']], optional): Thumbnails
            video_thumbs (Optional[List['TypeVideoSize']], optional): Video thumbnails
        """

        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.date = date
        self.mime_type = mime_type
        self.size = size
        self.dc_id = dc_id
        self.attributes = attributes
        self.thumbs = thumbs
        self.video_thumbs = video_thumbs

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8\xc4\xd4\x8f' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.bytes(self.file_reference)
                writer.int(self.date)
                writer.string(self.mime_type)
                writer.long(self.size)

                if flags(self.thumbs, 0):
                    writer.vector(
                        self.thumbs,
                        lambda value: writer.object(
                            value,
                            group_id=0X478D00B0
                        )
                    )

                if flags(self.video_thumbs, 1):
                    writer.vector(
                        self.video_thumbs,
                        lambda value: writer.object(
                            value,
                            group_id=0X32B0FC60
                        )
                    )
                writer.int(self.dc_id)
                writer.vector(
                    self.attributes,
                    lambda value: writer.object(
                        value,
                        group_id=0X9EBF3A46
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        file_reference_ = reader.bytes()
        date_ = reader.int()
        mime_type_ = reader.string()
        size_ = reader.long()
        thumbs_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X478D00B0
                )
            )
            if flags(0) else None
        )

        video_thumbs_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X32B0FC60
                )
            )
            if flags(1) else None
        )

        dc_id_ = reader.int()
        attributes_ = reader.vector(
            lambda: reader.object(
                group_id=0X9EBF3A46
            )
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            file_reference=file_reference_,
            date=date_,
            mime_type=mime_type_,
            size=size_,
            dc_id=dc_id_,
            attributes=attributes_,
            thumbs=thumbs_,
            video_thumbs=video_thumbs_
        )

TypeDocument = Union[
    DocumentEmpty,
    Document
]