
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class EncryptedFileEmpty(TLObject, family='TypeEncryptedFile'):
    """
    Empty constructor, non-existing file.
    """

    _id = 0XC21F497E
    _group_id = 0X77918D96


    def to_bytes(self, boxed: bool=True):
        return b'~I\x1f\xc2' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class EncryptedFile(TLObject, family='TypeEncryptedFile'):
    """
    Encrypted file.
    """

    _id = 0XA8008CD8
    _group_id = 0X77918D96

    def __init__(
        self,
        id: int,
        access_hash: int,
        size: int,
        dc_id: int,
        key_fingerprint: int
    ):

        """
        Encrypted file.

        Args:
            id (int): File ID
            access_hash (int): Checking sum depending on user ID
            size (int): File size in bytes
            dc_id (int): Number of data center
            key_fingerprint (int): 32-bit fingerprint of key used for file encryption
        """

        self.id = id
        self.access_hash = access_hash
        self.size = size
        self.dc_id = dc_id
        self.key_fingerprint = key_fingerprint

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8\x8c\x00\xa8' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)
            writer.long(self.size)
            writer.int(self.dc_id)
            writer.int(self.key_fingerprint)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()
        size_ = reader.long()
        dc_id_ = reader.int()
        key_fingerprint_ = reader.int()

        return cls(
            id=id_,
            access_hash=access_hash_,
            size=size_,
            dc_id=dc_id_,
            key_fingerprint=key_fingerprint_
        )

TypeEncryptedFile = Union[
    EncryptedFileEmpty,
    EncryptedFile
]