
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .document import TypeDocument
    from ...gadgets.byteutils import Reader


class Game(TLObject, family='TypeGame'):
    """
    Indicates an already sent game
    """

    _id = 0XBDF9653B
    _group_id = 0X351303FF

    def __init__(
        self,
        id: int,
        access_hash: int,
        short_name: str,
        title: str,
        description: str,
        photo: 'TypePhoto',
        document: Optional['TypeDocument'] = None
    ):

        """
        Indicates an already sent game

        Args:
            id (int): ID of the game
            access_hash (int): Access hash of the game
            short_name (str): Short name for the game
            title (str): Title of the game
            description (str): Game description
            photo ('TypePhoto'): Game preview
            document (Optional['TypeDocument'], optional): Optional attached document
        """

        self.id = id
        self.access_hash = access_hash
        self.short_name = short_name
        self.title = title
        self.description = description
        self.photo = photo
        self.document = document

    def to_bytes(self, boxed: bool=True):
        with Writer(b';e\xf9\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.string(self.short_name)
                writer.string(self.title)
                writer.string(self.description)
                writer.object(
                    self.photo,
                    group_id=0XDDAD9CAC
                )

                if flags(self.document, 0):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        short_name_ = reader.string()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(0) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            short_name=short_name_,
            title=title_,
            description=description_,
            photo=photo_,
            document=document_
        )

TypeGame = Game