
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class GroupCallStreamChannel(TLObject, family='TypeGroupCallStreamChannel'):
    """
    Info about an RTMP stream in a group call or livestream
    """

    _id = 0X80EB48AF
    _group_id = 0X7F68C3E0

    def __init__(
        self,
        channel: int,
        scale: int,
        last_timestamp_ms: int
    ):

        """
        Info about an RTMP stream in a group call or livestream

        Args:
            channel (int): Channel ID
            scale (int): Specifies the duration of the video segment to fetch in milliseconds, by bitshifting 1000 to the right scale times: duration_ms := 1000 >> scale.
            last_timestamp_ms (int): Last seen timestamp to easily start fetching livestream chunks using [inputGroupCallStream](https://core.telegram.org/constructor/inputGroupCallStream)
        """

        self.channel = channel
        self.scale = scale
        self.last_timestamp_ms = last_timestamp_ms

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xafH\xeb\x80' if boxed else b'') as writer:
            writer.int(self.channel)
            writer.int(self.scale)
            writer.long(self.last_timestamp_ms)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_ = reader.int()
        scale_ = reader.int()
        last_timestamp_ms_ = reader.long()

        return cls(
            channel=channel_,
            scale=scale_,
            last_timestamp_ms=last_timestamp_ms_
        )

TypeGroupCallStreamChannel = GroupCallStreamChannel