
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..timezone import TypeTimezone
    from ....gadgets.byteutils import Reader


class TimezonesListNotModified(TLObject, family='TypeHelpTimezonesList'):
    """
    The timezone list has not changed.
    """

    _id = 0X970708CC
    _group_id = 0XF1EF5A84


    def to_bytes(self, boxed: bool=True):
        return b'\xcc\x08\x07\x97' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class TimezonesList(TLObject, family='TypeHelpTimezonesList'):
    """
    Timezone information that may be used elsewhere in the API, such as to set [Telegram Business opening hours](https://core.telegram.org/api/business#opening-hours).
    """

    _id = 0X7B74ED71
    _group_id = 0XF1EF5A84

    def __init__(
        self,
        timezones: List['TypeTimezone'],
        hash: int
    ):

        """
        Timezone information that may be used elsewhere in the API, such as to set [Telegram Business opening hours](https://core.telegram.org/api/business#opening-hours).

        Args:
            timezones (List['TypeTimezone']): Timezones
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
        """

        self.timezones = timezones
        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'q\xedt{' if boxed else b'') as writer:
            writer.vector(
                self.timezones,
                lambda value: writer.object(
                    value,
                    group_id=0X8A2F85B1
                )
            )
            writer.int(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        timezones_ = reader.vector(
            lambda: reader.object(
                group_id=0X8A2F85B1
            )
        )

        hash_ = reader.int()

        return cls(
            timezones=timezones_,
            hash=hash_
        )

TypeHelpTimezonesList = Union[
    TimezonesListNotModified,
    TimezonesList
]