
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputCheckPasswordEmpty(TLObject, family='TypeInputCheckPasswordSRP'):
    """
    There is no password
    """

    _id = 0X9880F658
    _group_id = 0X9F1A3F43


    def to_bytes(self, boxed: bool=True):
        return b'X\xf6\x80\x98' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputCheckPasswordSRP(TLObject, family='TypeInputCheckPasswordSRP'):
    """
    Constructor for checking the validity of a 2FA SRP password (see [SRP](https://core.telegram.org/api/srp))
    """

    _id = 0XD27FF082
    _group_id = 0X9F1A3F43

    def __init__(
        self,
        srp_id: int,
        A: bytes,
        M1: bytes
    ):

        """
        Constructor for checking the validity of a 2FA SRP password (see [SRP](https://core.telegram.org/api/srp))

        Args:
            srp_id (int): [SRP ID](https://core.telegram.org/api/srp)
            A (bytes): A parameter (see [SRP](https://core.telegram.org/api/srp))
            M1 (bytes): M1 parameter (see [SRP](https://core.telegram.org/api/srp))
        """

        self.srp_id = srp_id
        self.A = A
        self.M1 = M1

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x82\xf0\x7f\xd2' if boxed else b'') as writer:
            writer.long(self.srp_id)
            writer.bytes(self.A)
            writer.bytes(self.M1)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        srp_id_ = reader.long()
        A_ = reader.bytes()
        M1_ = reader.bytes()

        return cls(
            srp_id=srp_id_,
            A=A_,
            M1=M1_
        )

TypeInputCheckPasswordSRP = Union[
    InputCheckPasswordEmpty,
    InputCheckPasswordSRP
]