
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from .input_user import TypeInputUser
    from .text_with_entities import TypeTextWithEntities
    from ...gadgets.byteutils import Reader
    from .input_saved_star_gift import TypeInputSavedStarGift
    from .premium_gift_code_option import TypePremiumGiftCodeOption
    from .input_store_payment_purpose import TypeInputStorePaymentPurpose


class InputInvoiceMessage(TLObject, family='TypeInputInvoice'):
    """
    An invoice contained in a [messageMediaInvoice](https://core.telegram.org/constructor/messageMediaInvoice) message or [paid media](https://core.telegram.org/api/paid-media).
    """

    _id = 0XC5B56859
    _group_id = 0X70F585EC

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int
    ):

        """
        An invoice contained in a [messageMediaInvoice](https://core.telegram.org/constructor/messageMediaInvoice) message or [paid media](https://core.telegram.org/api/paid-media).

        Args:
            peer ('TypeInputPeer'): Chat where the invoice/paid media was sent
            msg_id (int): Message ID
        """

        self.peer = peer
        self.msg_id = msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Yh\xb5\xc5' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        msg_id_ = reader.int()

        return cls(
            peer=peer_,
            msg_id=msg_id_
        )

class InputInvoiceSlug(TLObject, family='TypeInputInvoice'):
    """
    An invoice slug taken from an [invoice deep link](https://core.telegram.org/api/links#invoice-links) or from the [premium_invoice_slug app config parameter](https://core.telegram.org/api/config#premium-invoice-slug)
    """

    _id = 0XC326CAEF
    _group_id = 0X70F585EC

    def __init__(
        self,
        slug: str
    ):

        """
        An invoice slug taken from an [invoice deep link](https://core.telegram.org/api/links#invoice-links) or from the [premium_invoice_slug app config parameter](https://core.telegram.org/api/config#premium-invoice-slug)

        Args:
            slug (str): The invoice slug
        """

        self.slug = slug

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xef\xca&\xc3' if boxed else b'') as writer:
            writer.string(self.slug)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        slug_ = reader.string()

        return cls(
            slug=slug_
        )

class InputInvoicePremiumGiftCode(TLObject, family='TypeInputInvoice'):
    """
    Used if the user wishes to start a channel/supergroup [giveaway](https://core.telegram.org/api/giveaways) or send some [giftcodes](https://core.telegram.org/api/giveaways) to members of a channel/supergroup, in exchange for [boosts](https://core.telegram.org/api/boost).
    """

    _id = 0X98986C0D
    _group_id = 0X70F585EC

    def __init__(
        self,
        purpose: 'TypeInputStorePaymentPurpose',
        option: 'TypePremiumGiftCodeOption'
    ):

        """
        Used if the user wishes to start a channel/supergroup [giveaway](https://core.telegram.org/api/giveaways) or send some [giftcodes](https://core.telegram.org/api/giveaways) to members of a channel/supergroup, in exchange for [boosts](https://core.telegram.org/api/boost).

        Args:
            purpose ('TypeInputStorePaymentPurpose'): Should be populated with [inputStorePaymentPremiumGiveaway](https://core.telegram.org/constructor/inputStorePaymentPremiumGiveaway) for [giveaways](https://core.telegram.org/api/giveaways) and [inputStorePaymentPremiumGiftCode](https://core.telegram.org/constructor/inputStorePaymentPremiumGiftCode) for [gifts](https://core.telegram.org/api/giveaways).
            option ('TypePremiumGiftCodeOption'): Should be populated with one of the giveaway options returned by [payments.getPremiumGiftCodeOptions](https://core.telegram.org/method/payments.getPremiumGiftCodeOptions), see the [giveaways](https://core.telegram.org/api/giveaways) documentation for more info.
        """

        self.purpose = purpose
        self.option = option

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\rl\x98\x98' if boxed else b'') as writer:
            writer.object(
                self.purpose,
                group_id=0XECBAD07B
            )
            writer.object(
                self.option,
                group_id=0X4B2119E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        purpose_ = reader.object(
            group_id=0XECBAD07B
        )

        option_ = reader.object(
            group_id=0X4B2119E1
        )

        return cls(
            purpose=purpose_,
            option=option_
        )

class InputInvoiceStars(TLObject, family='TypeInputInvoice'):
    """
    Used to top up the [Telegram Stars](https://core.telegram.org/api/stars) balance of the current account or someone else's account, or to start a [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways).
    """

    _id = 0X65F00CE3
    _group_id = 0X70F585EC

    def __init__(
        self,
        purpose: 'TypeInputStorePaymentPurpose'
    ):

        """
        Used to top up the [Telegram Stars](https://core.telegram.org/api/stars) balance of the current account or someone else's account, or to start a [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways).

        Args:
            purpose ('TypeInputStorePaymentPurpose'): An [inputStorePaymentStarsGiveaway](https://core.telegram.org/constructor/inputStorePaymentStarsGiveaway), [inputStorePaymentStarsTopup](https://core.telegram.org/constructor/inputStorePaymentStarsTopup) or [inputStorePaymentStarsGift](https://core.telegram.org/constructor/inputStorePaymentStarsGift).
        """

        self.purpose = purpose

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe3\x0c\xf0e' if boxed else b'') as writer:
            writer.object(
                self.purpose,
                group_id=0XECBAD07B
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        purpose_ = reader.object(
            group_id=0XECBAD07B
        )

        return cls(
            purpose=purpose_
        )

class InputInvoiceChatInviteSubscription(TLObject, family='TypeInputInvoice'):
    """
    Used to pay for a [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).
    """

    _id = 0X34E793F1
    _group_id = 0X70F585EC

    def __init__(
        self,
        hash: str
    ):

        """
        Used to pay for a [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).

        Args:
            hash (str): The [invitation link of the Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions)
        """

        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf1\x93\xe74' if boxed else b'') as writer:
            writer.string(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.string()

        return cls(
            hash=hash_
        )

class InputInvoiceStarGift(TLObject, family='TypeInputInvoice'):
    """
    Used to buy a [Telegram Star Gift, see here](https://core.telegram.org/api/gifts) for more info.
    """

    _id = 0XE8625E92
    _group_id = 0X70F585EC

    def __init__(
        self,
        peer: 'TypeInputPeer',
        gift_id: int,
        hide_name: bool = False,
        include_upgrade: bool = False,
        message: Optional['TypeTextWithEntities'] = None
    ):

        """
        Used to buy a [Telegram Star Gift, see here](https://core.telegram.org/api/gifts) for more info.

        Args:
            peer ('TypeInputPeer'): ...
            gift_id (int): Identifier of the gift, from [starGift](https://core.telegram.org/constructor/starGift). id
            hide_name (bool, optional): If set, your name will be hidden if the destination user decides to display the gift on their profile (they will still see that you sent the gift)
            include_upgrade (bool, optional): ...
            message (Optional['TypeTextWithEntities'], optional): Optional message, attached with the gift. The maximum length for this field is specified in the [stargifts_message_length_max client configuration value](https://core.telegram.org/api/config#stargifts-message-length-max).
        """

        self.peer = peer
        self.gift_id = gift_id
        self.hide_name = hide_name
        self.include_upgrade = include_upgrade
        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92^b\xe8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.hide_name, 0)
                flags(self.include_upgrade, 2)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.long(self.gift_id)

                if flags(self.message, 1):
                    writer.object(
                        self.message,
                        group_id=0X5D96896
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        gift_id_ = reader.long()
        message_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(1) else None
        )

        return cls(
            peer=peer_,
            gift_id=gift_id_,
            hide_name=flags(0),
            include_upgrade=flags(2),
            message=message_
        )

class InputInvoiceStarGiftUpgrade(TLObject, family='TypeInputInvoice'):
    _id = 0X4D818D5D
    _group_id = 0X70F585EC

    def __init__(
        self,
        stargift: 'TypeInputSavedStarGift',
        keep_original_details: bool = False
    ):

        self.stargift = stargift
        self.keep_original_details = keep_original_details

    def to_bytes(self, boxed: bool=True):
        with Writer(b']\x8d\x81M' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.keep_original_details, 0)
                writer.object(
                    self.stargift,
                    group_id=0X777EA116
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stargift_ = reader.object(
            group_id=0X777EA116
        )

        return cls(
            stargift=stargift_,
            keep_original_details=flags(0)
        )

class InputInvoiceStarGiftTransfer(TLObject, family='TypeInputInvoice'):
    _id = 0X4A5F5BD9
    _group_id = 0X70F585EC

    def __init__(
        self,
        stargift: 'TypeInputSavedStarGift',
        to_id: 'TypeInputPeer'
    ):

        self.stargift = stargift
        self.to_id = to_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9[_J' if boxed else b'') as writer:
            writer.object(
                self.stargift,
                group_id=0X777EA116
            )
            writer.object(
                self.to_id,
                group_id=0X995DB9DF
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        stargift_ = reader.object(
            group_id=0X777EA116
        )

        to_id_ = reader.object(
            group_id=0X995DB9DF
        )

        return cls(
            stargift=stargift_,
            to_id=to_id_
        )

class InputInvoicePremiumGiftStars(TLObject, family='TypeInputInvoice'):
    _id = 0XDABAB2EF
    _group_id = 0X70F585EC

    def __init__(
        self,
        user_id: 'TypeInputUser',
        months: int,
        message: Optional['TypeTextWithEntities'] = None
    ):

        self.user_id = user_id
        self.months = months
        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xef\xb2\xba\xda' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )
                writer.int(self.months)

                if flags(self.message, 0):
                    writer.object(
                        self.message,
                        group_id=0X5D96896
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.object(
            group_id=0XB628962F
        )

        months_ = reader.int()
        message_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(0) else None
        )

        return cls(
            user_id=user_id_,
            months=months_,
            message=message_
        )

class InputInvoiceBusinessBotTransferStars(TLObject, family='TypeInputInvoice'):
    _id = 0XF4997E42
    _group_id = 0X70F585EC

    def __init__(
        self,
        bot: 'TypeInputUser',
        stars: int
    ):

        self.bot = bot
        self.stars = stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'B~\x99\xf4' if boxed else b'') as writer:
            writer.object(
                self.bot,
                group_id=0XB628962F
            )
            writer.long(self.stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        bot_ = reader.object(
            group_id=0XB628962F
        )

        stars_ = reader.long()

        return cls(
            bot=bot_,
            stars=stars_
        )

class InputInvoiceStarGiftResale(TLObject, family='TypeInputInvoice'):
    _id = 0XC39F5324
    _group_id = 0X70F585EC

    def __init__(
        self,
        slug: str,
        to_id: 'TypeInputPeer',
        ton: bool = False
    ):

        self.slug = slug
        self.to_id = to_id
        self.ton = ton

    def to_bytes(self, boxed: bool=True):
        with Writer(b'$S\x9f\xc3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.ton, 0)
                writer.string(self.slug)
                writer.object(
                    self.to_id,
                    group_id=0X995DB9DF
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        slug_ = reader.string()
        to_id_ = reader.object(
            group_id=0X995DB9DF
        )

        return cls(
            slug=slug_,
            to_id=to_id_,
            ton=flags(0)
        )

class InputInvoiceStarGiftPrepaidUpgrade(TLObject, family='TypeInputInvoice'):
    _id = 0X9A0B48B8
    _group_id = 0X70F585EC

    def __init__(
        self,
        peer: 'TypeInputPeer',
        hash: str
    ):

        self.peer = peer
        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb8H\x0b\x9a' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.string(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        hash_ = reader.string()

        return cls(
            peer=peer_,
            hash=hash_
        )

TypeInputInvoice = Union[
    InputInvoiceMessage,
    InputInvoiceSlug,
    InputInvoicePremiumGiftCode,
    InputInvoiceStars,
    InputInvoiceChatInviteSubscription,
    InputInvoiceStarGift,
    InputInvoiceStarGiftUpgrade,
    InputInvoiceStarGiftTransfer,
    InputInvoicePremiumGiftStars,
    InputInvoiceBusinessBotTransferStars,
    InputInvoiceStarGiftResale,
    InputInvoiceStarGiftPrepaidUpgrade
]