
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputStickerSetEmpty(TLObject, family='TypeInputStickerSet'):
    """
    Empty constructor
    """

    _id = 0XFFB62B95
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\x95+\xb6\xff' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetID(TLObject, family='TypeInputStickerSet'):
    """
    Stickerset by ID
    """

    _id = 0X9DE7A269
    _group_id = 0X919D8BA5

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Stickerset by ID

        Args:
            id (int): ID
            access_hash (int): Access hash
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'i\xa2\xe7\x9d' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

class InputStickerSetShortName(TLObject, family='TypeInputStickerSet'):
    """
    Stickerset by short name, from a [stickerset deep link](https://core.telegram.org/api/links#stickerset-links)
    """

    _id = 0X861CC8A0
    _group_id = 0X919D8BA5

    def __init__(
        self,
        short_name: str
    ):

        """
        Stickerset by short name, from a [stickerset deep link](https://core.telegram.org/api/links#stickerset-links)

        Args:
            short_name (str): Short name from a [stickerset deep link](https://core.telegram.org/api/links#stickerset-links)
        """

        self.short_name = short_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa0\xc8\x1c\x86' if boxed else b'') as writer:
            writer.string(self.short_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        short_name_ = reader.string()

        return cls(
            short_name=short_name_
        )

class InputStickerSetAnimatedEmoji(TLObject, family='TypeInputStickerSet'):
    """
    Animated emojis stickerset
    """

    _id = 0X28703C8
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\xc8\x03\x87\x02' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetDice(TLObject, family='TypeInputStickerSet'):
    """
    Used for fetching [animated dice stickers](https://core.telegram.org/api/dice)
    """

    _id = 0XE67F520E
    _group_id = 0X919D8BA5

    def __init__(
        self,
        emoticon: str
    ):

        """
        Used for fetching [animated dice stickers](https://core.telegram.org/api/dice)

        Args:
            emoticon (str): The emoji, for now ,  and  are supported
        """

        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0eR\x7f\xe6' if boxed else b'') as writer:
            writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoticon_ = reader.string()

        return cls(
            emoticon=emoticon_
        )

class InputStickerSetAnimatedEmojiAnimations(TLObject, family='TypeInputStickerSet'):
    """
    Animated emoji reaction stickerset (contains animations to play when a user clicks on a given animated emoji)
    """

    _id = 0XCDE3739
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'97\xde\x0c' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetPremiumGifts(TLObject, family='TypeInputStickerSet'):
    """
    Stickers to show when receiving a gifted Telegram Premium subscription
    """

    _id = 0XC88B3B02
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\x02;\x8b\xc8' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetEmojiGenericAnimations(TLObject, family='TypeInputStickerSet'):
    """
    Generic animation stickerset containing animations to play when [reacting to messages using a normal emoji without a custom animation](https://core.telegram.org/api/reactions)
    """

    _id = 0X4C4D4CE
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\xce\xd4\xc4\x04' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetEmojiDefaultStatuses(TLObject, family='TypeInputStickerSet'):
    """
    Default [custom emoji status](https://core.telegram.org/api/emoji-status) stickerset
    """

    _id = 0X29D0F5EE
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\xee\xf5\xd0)' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetEmojiDefaultTopicIcons(TLObject, family='TypeInputStickerSet'):
    """
    Default [custom emoji](https://core.telegram.org/api/custom-emoji) stickerset for [forum topic icons](https://core.telegram.org/api/forum#forum-topics)
    """

    _id = 0X44C1F8E9
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\xe9\xf8\xc1D' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetEmojiChannelDefaultStatuses(TLObject, family='TypeInputStickerSet'):
    """
    Default [custom emoji status](https://core.telegram.org/api/emoji-status) stickerset for channel statuses
    """

    _id = 0X49748553
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'S\x85tI' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputStickerSetTonGifts(TLObject, family='TypeInputStickerSet'):
    _id = 0X1CF671A0
    _group_id = 0X919D8BA5


    def to_bytes(self, boxed: bool=True):
        return b'\xa0q\xf6\x1c' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeInputStickerSet = Union[
    InputStickerSetEmpty,
    InputStickerSetID,
    InputStickerSetShortName,
    InputStickerSetAnimatedEmoji,
    InputStickerSetDice,
    InputStickerSetAnimatedEmojiAnimations,
    InputStickerSetPremiumGifts,
    InputStickerSetEmojiGenericAnimations,
    InputStickerSetEmojiDefaultStatuses,
    InputStickerSetEmojiDefaultTopicIcons,
    InputStickerSetEmojiChannelDefaultStatuses,
    InputStickerSetTonGifts
]