
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_document import TypeInputDocument
    from .input_geo_point import TypeInputGeoPoint
    from ...gadgets.byteutils import Reader


class InputWebFileLocation(TLObject, family='TypeInputWebFileLocation'):
    """
    Location of a remote HTTP(s) file
    """

    _id = 0XC239D686
    _group_id = 0XF330BCFC

    def __init__(
        self,
        url: str,
        access_hash: int
    ):

        """
        Location of a remote HTTP(s) file

        Args:
            url (str): HTTP URL of file
            access_hash (int): Access hash
        """

        self.url = url
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x86\xd69\xc2' if boxed else b'') as writer:
            writer.string(self.url)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        access_hash_ = reader.long()

        return cls(
            url=url_,
            access_hash=access_hash_
        )

class InputWebFileGeoPointLocation(TLObject, family='TypeInputWebFileLocation'):
    """
    Used to download a server-generated image with the map preview from a [geoPoint](https://core.telegram.org/constructor/geoPoint), see the [webfile docs for more info](https://core.telegram.org/api/files#downloading-webfiles).
    """

    _id = 0X9F2221C9
    _group_id = 0XF330BCFC

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint',
        access_hash: int,
        w: int,
        h: int,
        zoom: int,
        scale: int
    ):

        """
        Used to download a server-generated image with the map preview from a [geoPoint](https://core.telegram.org/constructor/geoPoint), see the [webfile docs for more info](https://core.telegram.org/api/files#downloading-webfiles).

        Args:
            geo_point ('TypeInputGeoPoint'): Generated from the lat, long and accuracy_radius parameters of the [geoPoint](https://core.telegram.org/constructor/geoPoint)
            access_hash (int): Access hash of the [geoPoint](https://core.telegram.org/constructor/geoPoint)
            w (int): Map width in pixels before applying scale; 16-1024
            h (int): Map height in pixels before applying scale; 16-1024
            zoom (int): Map zoom level; 13-20
            scale (int): Map scale; 1-3
        """

        self.geo_point = geo_point
        self.access_hash = access_hash
        self.w = w
        self.h = h
        self.zoom = zoom
        self.scale = scale

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc9!"\x9f' if boxed else b'') as writer:
            writer.object(
                self.geo_point,
                group_id=0XF78B3873
            )
            writer.long(self.access_hash)
            writer.int(self.w)
            writer.int(self.h)
            writer.int(self.zoom)
            writer.int(self.scale)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        geo_point_ = reader.object(
            group_id=0XF78B3873
        )

        access_hash_ = reader.long()
        w_ = reader.int()
        h_ = reader.int()
        zoom_ = reader.int()
        scale_ = reader.int()

        return cls(
            geo_point=geo_point_,
            access_hash=access_hash_,
            w=w_,
            h=h_,
            zoom=zoom_,
            scale=scale_
        )

class InputWebFileAudioAlbumThumbLocation(TLObject, family='TypeInputWebFileLocation'):
    """
    Used to download an album cover for any music file using [upload.getWebFile](https://core.telegram.org/method/upload.getWebFile), see the [webfile docs for more info](https://core.telegram.org/api/files#downloading-webfiles).
    """

    _id = 0XF46FE924
    _group_id = 0XF330BCFC

    def __init__(
        self,
        small: bool = False,
        document: Optional['TypeInputDocument'] = None,
        title: Optional[str] = None,
        performer: Optional[str] = None
    ):

        """
        Used to download an album cover for any music file using [upload.getWebFile](https://core.telegram.org/method/upload.getWebFile), see the [webfile docs for more info](https://core.telegram.org/api/files#downloading-webfiles).

        Args:
            small (bool, optional): Used to return a thumbnail with 100x100 resolution (instead of the default 600x600)
            document (Optional['TypeInputDocument'], optional): The audio file in question: must NOT be provided in secret chats, provide the title and performer fields instead.
            title (Optional[str], optional): Song title: should only be used in secret chats, in normal chats provide document instead, as it has more lax rate limits.
            performer (Optional[str], optional): Song performer: should only be used in secret chats, in normal chats provide document instead, as it has more lax rate limits.
        """

        self.small = small
        self.document = document
        self.title = title
        self.performer = performer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'$\xe9o\xf4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.small, 2)

                if flags(self.document, 0):
                    writer.object(
                        self.document,
                        group_id=0X84313E
                    )

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.performer, 1):
                    writer.string(self.performer)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        document_ = (
            reader.object(
                group_id=0X84313E
            )
            if flags(0) else None
        )

        title_ = (
            reader.string()
            if flags(1) else None
        )

        performer_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            small=flags(2),
            document=document_,
            title=title_,
            performer=performer_
        )

TypeInputWebFileLocation = Union[
    InputWebFileLocation,
    InputWebFileGeoPointLocation,
    InputWebFileAudioAlbumThumbLocation
]