
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .jsonobject_value import TypeJSONObjectValue
    from ...gadgets.byteutils import Reader


class JsonNull(TLObject, family='TypeJSONValue'):
    """
    null JSON value
    """

    _id = 0X3F6D7B68
    _group_id = 0XBBD8AEDA


    def to_bytes(self, boxed: bool=True):
        return b'h{m?' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class JsonBool(TLObject, family='TypeJSONValue'):
    """
    JSON boolean value
    """

    _id = 0XC7345E6A
    _group_id = 0XBBD8AEDA

    def __init__(
        self,
        value: bool
    ):

        """
        JSON boolean value

        Args:
            value (bool): Value
        """

        self.value = value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'j^4\xc7' if boxed else b'') as writer:
            writer.object(
                self.value,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        value_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            value=value_
        )

class JsonNumber(TLObject, family='TypeJSONValue'):
    """
    JSON numeric value
    """

    _id = 0X2BE0DFA4
    _group_id = 0XBBD8AEDA

    def __init__(
        self,
        value: float
    ):

        """
        JSON numeric value

        Args:
            value (float): Value
        """

        self.value = value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa4\xdf\xe0+' if boxed else b'') as writer:
            writer.double(self.value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        value_ = reader.double()

        return cls(
            value=value_
        )

class JsonString(TLObject, family='TypeJSONValue'):
    """
    JSON string
    """

    _id = 0XB71E767A
    _group_id = 0XBBD8AEDA

    def __init__(
        self,
        value: str
    ):

        """
        JSON string

        Args:
            value (str): Value
        """

        self.value = value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'zv\x1e\xb7' if boxed else b'') as writer:
            writer.string(self.value)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        value_ = reader.string()

        return cls(
            value=value_
        )

class JsonArray(TLObject, family='TypeJSONValue'):
    """
    JSON array
    """

    _id = 0XF7444763
    _group_id = 0XBBD8AEDA

    def __init__(
        self,
        value: List['TypeJSONValue']
    ):

        """
        JSON array

        Args:
            value (List['TypeJSONValue']): JSON values
        """

        self.value = value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'cGD\xf7' if boxed else b'') as writer:
            writer.vector(
                self.value,
                lambda value: writer.object(
                    value,
                    group_id=0XBBD8AEDA
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        value_ = reader.vector(
            lambda: reader.object(
                group_id=0XBBD8AEDA
            )
        )

        return cls(
            value=value_
        )

class JsonObject(TLObject, family='TypeJSONValue'):
    """
    JSON object value
    """

    _id = 0X99C1D49D
    _group_id = 0XBBD8AEDA

    def __init__(
        self,
        value: List['TypeJSONObjectValue']
    ):

        """
        JSON object value

        Args:
            value (List['TypeJSONObjectValue']): Values
        """

        self.value = value

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9d\xd4\xc1\x99' if boxed else b'') as writer:
            writer.vector(
                self.value,
                lambda value: writer.object(
                    value,
                    group_id=0X3F41CCB6
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        value_ = reader.vector(
            lambda: reader.object(
                group_id=0X3F41CCB6
            )
        )

        return cls(
            value=value_
        )

TypeJSONValue = Union[
    JsonNull,
    JsonBool,
    JsonNumber,
    JsonString,
    JsonArray,
    JsonObject
]