
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class MediaAreaCoordinates(TLObject, family='TypeMediaAreaCoordinates'):
    """
    Coordinates and size of a clicable rectangular area on top of a story.
    """

    _id = 0XCFC9E002
    _group_id = 0X195AE81C

    def __init__(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        rotation: float,
        radius: Optional[float] = None
    ):

        """
        Coordinates and size of a clicable rectangular area on top of a story.

        Args:
            x (float): The abscissa of the rectangle's center, as a percentage of the media width (0-100).
            y (float): The ordinate of the rectangle's center, as a percentage of the media height (0-100).
            w (float): The width of the rectangle, as a percentage of the media width (0-100).
            h (float): The height of the rectangle, as a percentage of the media height (0-100).
            rotation (float): Clockwise rotation angle of the rectangle, in degrees (0-360).
            radius (Optional[float], optional): The radius of the rectangle corner rounding, as a percentage of the media width.
        """

        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.rotation = rotation
        self.radius = radius

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x02\xe0\xc9\xcf' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.double(self.x)
                writer.double(self.y)
                writer.double(self.w)
                writer.double(self.h)
                writer.double(self.rotation)

                if flags(self.radius, 0):
                    writer.double(self.radius)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        x_ = reader.double()
        y_ = reader.double()
        w_ = reader.double()
        h_ = reader.double()
        rotation_ = reader.double()
        radius_ = (
            reader.double()
            if flags(0) else None
        )

        return cls(
            x=x_,
            y=y_,
            w=w_,
            h=h_,
            rotation=rotation_,
            radius=radius_
        )

TypeMediaAreaCoordinates = MediaAreaCoordinates