
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .photo import TypePhoto
    from .bot_app import TypeBotApp
    from .star_gift import TypeStarGift
    from .todo_item import TypeTodoItem
    from .chat_theme import TypeChatTheme
    from .wall_paper import TypeWallPaper
    from .secure_value import TypeSecureValue
    from .stars_amount import TypeStarsAmount
    from .payment_charge import TypePaymentCharge
    from .requested_peer import TypeRequestedPeer
    from .input_group_call import TypeInputGroupCall
    from .secure_value_type import TypeSecureValueType
    from .text_with_entities import TypeTextWithEntities
    from ...gadgets.byteutils import Reader
    from .payment_requested_info import TypePaymentRequestedInfo
    from .phone_call_discard_reason import TypePhoneCallDiscardReason
    from .secure_credentials_encrypted import TypeSecureCredentialsEncrypted


class MessageActionEmpty(TLObject, family='TypeMessageAction'):
    """
    Empty constructor.
    """

    _id = 0XB6AEF7B0
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'\xb0\xf7\xae\xb6' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionChatCreate(TLObject, family='TypeMessageAction'):
    """
    Group created
    """

    _id = 0XBD47CBAD
    _group_id = 0X753B3B70

    def __init__(
        self,
        title: str,
        users: List[int]
    ):

        """
        Group created

        Args:
            title (str): Group name
            users (List[int]): List of group members
        """

        self.title = title
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xad\xcbG\xbd' if boxed else b'') as writer:
            writer.string(self.title)
            writer.vector(
                self.users,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        users_ = reader.vector(
            reader.long
        )

        return cls(
            title=title_,
            users=users_
        )

class MessageActionChatEditTitle(TLObject, family='TypeMessageAction'):
    """
    Group name changed.
    """

    _id = 0XB5A1CE5A
    _group_id = 0X753B3B70

    def __init__(
        self,
        title: str
    ):

        """
        Group name changed.

        Args:
            title (str): New group name
        """

        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Z\xce\xa1\xb5' if boxed else b'') as writer:
            writer.string(self.title)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()

        return cls(
            title=title_
        )

class MessageActionChatEditPhoto(TLObject, family='TypeMessageAction'):
    """
    Group profile changed
    """

    _id = 0X7FCB13A8
    _group_id = 0X753B3B70

    def __init__(
        self,
        photo: 'TypePhoto'
    ):

        """
        Group profile changed

        Args:
            photo ('TypePhoto'): New group profile photo
        """

        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa8\x13\xcb\x7f' if boxed else b'') as writer:
            writer.object(
                self.photo,
                group_id=0XDDAD9CAC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        return cls(
            photo=photo_
        )

class MessageActionChatDeletePhoto(TLObject, family='TypeMessageAction'):
    """
    Group profile photo removed.
    """

    _id = 0X95E3FBEF
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'\xef\xfb\xe3\x95' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionChatAddUser(TLObject, family='TypeMessageAction'):
    """
    New member in the group
    """

    _id = 0X15CEFD00
    _group_id = 0X753B3B70

    def __init__(
        self,
        users: List[int]
    ):

        """
        New member in the group

        Args:
            users (List[int]): Users that were invited to the chat
        """

        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x00\xfd\xce\x15' if boxed else b'') as writer:
            writer.vector(
                self.users,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        users_ = reader.vector(
            reader.long
        )

        return cls(
            users=users_
        )

class MessageActionChatDeleteUser(TLObject, family='TypeMessageAction'):
    """
    User left the group.
    """

    _id = 0XA43F30CC
    _group_id = 0X753B3B70

    def __init__(
        self,
        user_id: int
    ):

        """
        User left the group.

        Args:
            user_id (int): Leaving user ID
        """

        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcc0?\xa4' if boxed else b'') as writer:
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()

        return cls(
            user_id=user_id_
        )

class MessageActionChatJoinedByLink(TLObject, family='TypeMessageAction'):
    """
    A user joined the chat via an invite link
    """

    _id = 0X31224C3
    _group_id = 0X753B3B70

    def __init__(
        self,
        inviter_id: int
    ):

        """
        A user joined the chat via an invite link

        Args:
            inviter_id (int): ID of the user that created the invite link
        """

        self.inviter_id = inviter_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc3$\x12\x03' if boxed else b'') as writer:
            writer.long(self.inviter_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        inviter_id_ = reader.long()

        return cls(
            inviter_id=inviter_id_
        )

class MessageActionChannelCreate(TLObject, family='TypeMessageAction'):
    """
    The channel was created
    """

    _id = 0X95D2AC92
    _group_id = 0X753B3B70

    def __init__(
        self,
        title: str
    ):

        """
        The channel was created

        Args:
            title (str): Original channel/supergroup title
        """

        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92\xac\xd2\x95' if boxed else b'') as writer:
            writer.string(self.title)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()

        return cls(
            title=title_
        )

class MessageActionChatMigrateTo(TLObject, family='TypeMessageAction'):
    """
    Indicates the chat was [migrated](https://core.telegram.org/api/channel) to the specified supergroup
    """

    _id = 0XE1037F92
    _group_id = 0X753B3B70

    def __init__(
        self,
        channel_id: int
    ):

        """
        Indicates the chat was [migrated](https://core.telegram.org/api/channel) to the specified supergroup

        Args:
            channel_id (int): The supergroup it was migrated to
        """

        self.channel_id = channel_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92\x7f\x03\xe1' if boxed else b'') as writer:
            writer.long(self.channel_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()

        return cls(
            channel_id=channel_id_
        )

class MessageActionChannelMigrateFrom(TLObject, family='TypeMessageAction'):
    """
    Indicates the channel was [migrated](https://core.telegram.org/api/channel) from the specified chat
    """

    _id = 0XEA3948E9
    _group_id = 0X753B3B70

    def __init__(
        self,
        title: str,
        chat_id: int
    ):

        """
        Indicates the channel was [migrated](https://core.telegram.org/api/channel) from the specified chat

        Args:
            title (str): The old chat title
            chat_id (int): The old chat ID
        """

        self.title = title
        self.chat_id = chat_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe9H9\xea' if boxed else b'') as writer:
            writer.string(self.title)
            writer.long(self.chat_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        chat_id_ = reader.long()

        return cls(
            title=title_,
            chat_id=chat_id_
        )

class MessageActionPinMessage(TLObject, family='TypeMessageAction'):
    """
    A message was pinned
    """

    _id = 0X94BD38ED
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'\xed8\xbd\x94' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionHistoryClear(TLObject, family='TypeMessageAction'):
    """
    Chat history was cleared
    """

    _id = 0X9FBAB604
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'\x04\xb6\xba\x9f' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionGameScore(TLObject, family='TypeMessageAction'):
    """
    Someone scored in a game
    """

    _id = 0X92A72876
    _group_id = 0X753B3B70

    def __init__(
        self,
        game_id: int,
        score: int
    ):

        """
        Someone scored in a game

        Args:
            game_id (int): Game ID
            score (int): Score
        """

        self.game_id = game_id
        self.score = score

    def to_bytes(self, boxed: bool=True):
        with Writer(b'v(\xa7\x92' if boxed else b'') as writer:
            writer.long(self.game_id)
            writer.int(self.score)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        game_id_ = reader.long()
        score_ = reader.int()

        return cls(
            game_id=game_id_,
            score=score_
        )

class MessageActionPaymentSentMe(TLObject, family='TypeMessageAction'):
    """
    A user just sent a payment to me (a bot)
    """

    _id = 0XFFA00CCC
    _group_id = 0X753B3B70

    def __init__(
        self,
        currency: str,
        total_amount: int,
        payload: bytes,
        charge: 'TypePaymentCharge',
        recurring_init: bool = False,
        recurring_used: bool = False,
        info: Optional['TypePaymentRequestedInfo'] = None,
        shipping_option_id: Optional[str] = None,
        subscription_until_date: Optional[int] = None
    ):

        """
        A user just sent a payment to me (a bot)

        Args:
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or XTR for [Telegram Stars](https://core.telegram.org/api/stars).
            total_amount (int): Price of the product in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            payload (bytes): Bot specified invoice payload
            charge ('TypePaymentCharge'): Provider payment identifier
            recurring_init (bool, optional): Whether this is the first payment of a recurring payment we just subscribed to
            recurring_used (bool, optional): Whether this payment is part of a recurring payment
            info (Optional['TypePaymentRequestedInfo'], optional): Order info provided by the user
            shipping_option_id (Optional[str], optional): Identifier of the shipping option chosen by the user
            subscription_until_date (Optional[int], optional): Expiration date of the [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).
        """

        self.currency = currency
        self.total_amount = total_amount
        self.payload = payload
        self.charge = charge
        self.recurring_init = recurring_init
        self.recurring_used = recurring_used
        self.info = info
        self.shipping_option_id = shipping_option_id
        self.subscription_until_date = subscription_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcc\x0c\xa0\xff' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.recurring_init, 2)
                flags(self.recurring_used, 3)
                writer.string(self.currency)
                writer.long(self.total_amount)
                writer.bytes(self.payload)

                if flags(self.info, 0):
                    writer.object(
                        self.info,
                        group_id=0X89AE5563
                    )

                if flags(self.shipping_option_id, 1):
                    writer.string(self.shipping_option_id)
                writer.object(
                    self.charge,
                    group_id=0XCF73DA8F
                )

                if flags(self.subscription_until_date, 4):
                    writer.int(self.subscription_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        currency_ = reader.string()
        total_amount_ = reader.long()
        payload_ = reader.bytes()
        info_ = (
            reader.object(
                group_id=0X89AE5563
            )
            if flags(0) else None
        )

        shipping_option_id_ = (
            reader.string()
            if flags(1) else None
        )

        charge_ = reader.object(
            group_id=0XCF73DA8F
        )

        subscription_until_date_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            currency=currency_,
            total_amount=total_amount_,
            payload=payload_,
            charge=charge_,
            recurring_init=flags(2),
            recurring_used=flags(3),
            info=info_,
            shipping_option_id=shipping_option_id_,
            subscription_until_date=subscription_until_date_
        )

class MessageActionPaymentSent(TLObject, family='TypeMessageAction'):
    """
    A payment was sent
    """

    _id = 0XC624B16E
    _group_id = 0X753B3B70

    def __init__(
        self,
        currency: str,
        total_amount: int,
        recurring_init: bool = False,
        recurring_used: bool = False,
        invoice_slug: Optional[str] = None,
        subscription_until_date: Optional[int] = None
    ):

        """
        A payment was sent

        Args:
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or XTR for [Telegram Stars](https://core.telegram.org/api/stars).
            total_amount (int): Price of the product in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            recurring_init (bool, optional): Whether this is the first payment of a recurring payment we just subscribed to
            recurring_used (bool, optional): Whether this payment is part of a recurring payment
            invoice_slug (Optional[str], optional): An invoice slug taken from an [invoice deep link](https://core.telegram.org/api/links#invoice-links) or from the [premium_invoice_slug app config parameter](https://core.telegram.org/api/config#premium-invoice-slug)
            subscription_until_date (Optional[int], optional): Expiration date of the [Telegram Star subscription](https://core.telegram.org/api/stars#star-subscriptions).
        """

        self.currency = currency
        self.total_amount = total_amount
        self.recurring_init = recurring_init
        self.recurring_used = recurring_used
        self.invoice_slug = invoice_slug
        self.subscription_until_date = subscription_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'n\xb1$\xc6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.recurring_init, 2)
                flags(self.recurring_used, 3)
                writer.string(self.currency)
                writer.long(self.total_amount)

                if flags(self.invoice_slug, 0):
                    writer.string(self.invoice_slug)

                if flags(self.subscription_until_date, 4):
                    writer.int(self.subscription_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        currency_ = reader.string()
        total_amount_ = reader.long()
        invoice_slug_ = (
            reader.string()
            if flags(0) else None
        )

        subscription_until_date_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            currency=currency_,
            total_amount=total_amount_,
            recurring_init=flags(2),
            recurring_used=flags(3),
            invoice_slug=invoice_slug_,
            subscription_until_date=subscription_until_date_
        )

class MessageActionPhoneCall(TLObject, family='TypeMessageAction'):
    """
    A phone call
    """

    _id = 0X80E11A7F
    _group_id = 0X753B3B70

    def __init__(
        self,
        call_id: int,
        video: bool = False,
        reason: Optional['TypePhoneCallDiscardReason'] = None,
        duration: Optional[int] = None
    ):

        """
        A phone call

        Args:
            call_id (int): Call ID
            video (bool, optional): Is this a video call?
            reason (Optional['TypePhoneCallDiscardReason'], optional): If the call has ended, the reason why it ended
            duration (Optional[int], optional): Duration of the call in seconds
        """

        self.call_id = call_id
        self.video = video
        self.reason = reason
        self.duration = duration

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f\x1a\xe1\x80' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.video, 2)
                writer.long(self.call_id)

                if flags(self.reason, 0):
                    writer.object(
                        self.reason,
                        group_id=0X7AB7DC85
                    )

                if flags(self.duration, 1):
                    writer.int(self.duration)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        call_id_ = reader.long()
        reason_ = (
            reader.object(
                group_id=0X7AB7DC85
            )
            if flags(0) else None
        )

        duration_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            call_id=call_id_,
            video=flags(2),
            reason=reason_,
            duration=duration_
        )

class MessageActionScreenshotTaken(TLObject, family='TypeMessageAction'):
    """
    A screenshot of the chat was taken
    """

    _id = 0X4792929B
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'\x9b\x92\x92G' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionCustomAction(TLObject, family='TypeMessageAction'):
    """
    Custom action (most likely not supported by the current layer, an upgrade might be needed)
    """

    _id = 0XFAE69F56
    _group_id = 0X753B3B70

    def __init__(
        self,
        message: str
    ):

        """
        Custom action (most likely not supported by the current layer, an upgrade might be needed)

        Args:
            message (str): Action message
        """

        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'V\x9f\xe6\xfa' if boxed else b'') as writer:
            writer.string(self.message)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        message_ = reader.string()

        return cls(
            message=message_
        )

class MessageActionBotAllowed(TLObject, family='TypeMessageAction'):
    """
    We have given the bot permission to send us direct messages.
    """

    _id = 0XC516D679
    _group_id = 0X753B3B70

    def __init__(
        self,
        attach_menu: bool = False,
        from_request: bool = False,
        domain: Optional[str] = None,
        app: Optional['TypeBotApp'] = None
    ):

        """
        We have given the bot permission to send us direct messages.

        Args:
            attach_menu (bool, optional): We have authorized the bot to send us messages by installing the bot's [attachment menu](https://core.telegram.org/api/bots/attach).
            from_request (bool, optional): We have allowed the bot to send us messages using [bots.allowSendMessage](https://core.telegram.org/method/bots.allowSendMessage).
            domain (Optional[str], optional): We have authorized the bot to send us messages by logging into a website via [Telegram Login](https://core.telegram.org/widgets/login); this field contains the domain name of the website on which the user has logged in.
            app (Optional['TypeBotApp'], optional): We have authorized the bot to send us messages by opening the specified [bot mini app](https://core.telegram.org/api/bots/webapps).
        """

        self.attach_menu = attach_menu
        self.from_request = from_request
        self.domain = domain
        self.app = app

    def to_bytes(self, boxed: bool=True):
        with Writer(b'y\xd6\x16\xc5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.attach_menu, 1)
                flags(self.from_request, 3)

                if flags(self.domain, 0):
                    writer.string(self.domain)

                if flags(self.app, 2):
                    writer.object(
                        self.app,
                        group_id=0XC9665A15
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        domain_ = (
            reader.string()
            if flags(0) else None
        )

        app_ = (
            reader.object(
                group_id=0XC9665A15
            )
            if flags(2) else None
        )

        return cls(
            attach_menu=flags(1),
            from_request=flags(3),
            domain=domain_,
            app=app_
        )

class MessageActionSecureValuesSentMe(TLObject, family='TypeMessageAction'):
    """
    Secure [telegram passport](https://core.telegram.org/passport) values were received
    """

    _id = 0X1B287353
    _group_id = 0X753B3B70

    def __init__(
        self,
        values: List['TypeSecureValue'],
        credentials: 'TypeSecureCredentialsEncrypted'
    ):

        """
        Secure [telegram passport](https://core.telegram.org/passport) values were received

        Args:
            values (List['TypeSecureValue']): Vector with information about documents and other Telegram Passport elements that were shared with the bot
            credentials ('TypeSecureCredentialsEncrypted'): Encrypted credentials required to decrypt the data
        """

        self.values = values
        self.credentials = credentials

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Ss(\x1b' if boxed else b'') as writer:
            writer.vector(
                self.values,
                lambda value: writer.object(
                    value,
                    group_id=0XF39C206D
                )
            )
            writer.object(
                self.credentials,
                group_id=0X18C0BB4B
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        values_ = reader.vector(
            lambda: reader.object(
                group_id=0XF39C206D
            )
        )

        credentials_ = reader.object(
            group_id=0X18C0BB4B
        )

        return cls(
            values=values_,
            credentials=credentials_
        )

class MessageActionSecureValuesSent(TLObject, family='TypeMessageAction'):
    """
    Request for secure [telegram passport](https://core.telegram.org/passport) values was sent
    """

    _id = 0XD95C6154
    _group_id = 0X753B3B70

    def __init__(
        self,
        types: List['TypeSecureValueType']
    ):

        """
        Request for secure [telegram passport](https://core.telegram.org/passport) values was sent

        Args:
            types (List['TypeSecureValueType']): Secure value types
        """

        self.types = types

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Ta\\\xd9' if boxed else b'') as writer:
            writer.vector(
                self.types,
                lambda value: writer.object(
                    value,
                    group_id=0X24ADF799
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        types_ = reader.vector(
            lambda: reader.object(
                group_id=0X24ADF799
            )
        )

        return cls(
            types=types_
        )

class MessageActionContactSignUp(TLObject, family='TypeMessageAction'):
    """
    A contact just signed up to telegram
    """

    _id = 0XF3F25F76
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'v_\xf2\xf3' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionGeoProximityReached(TLObject, family='TypeMessageAction'):
    """
    A user of the chat is now in proximity of another user
    """

    _id = 0X98E0D697
    _group_id = 0X753B3B70

    def __init__(
        self,
        from_id: 'TypePeer',
        to_id: 'TypePeer',
        distance: int
    ):

        """
        A user of the chat is now in proximity of another user

        Args:
            from_id ('TypePeer'): The user or chat that is now in proximity of to_id
            to_id ('TypePeer'): The user or chat that subscribed to [live geolocation proximity alerts](https://core.telegram.org/api/live-location#proximity-alert)
            distance (int): Distance, in meters (0-100000)
        """

        self.from_id = from_id
        self.to_id = to_id
        self.distance = distance

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x97\xd6\xe0\x98' if boxed else b'') as writer:
            writer.object(
                self.from_id,
                group_id=0XB4DECBCA
            )
            writer.object(
                self.to_id,
                group_id=0XB4DECBCA
            )
            writer.int(self.distance)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        from_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        to_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        distance_ = reader.int()

        return cls(
            from_id=from_id_,
            to_id=to_id_,
            distance=distance_
        )

class MessageActionGroupCall(TLObject, family='TypeMessageAction'):
    """
    The group call has ended
    """

    _id = 0X7A0D7F42
    _group_id = 0X753B3B70

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        duration: Optional[int] = None
    ):

        """
        The group call has ended

        Args:
            call ('TypeInputGroupCall'): Group call
            duration (Optional[int], optional): Group call duration
        """

        self.call = call
        self.duration = duration

    def to_bytes(self, boxed: bool=True):
        with Writer(b'B\x7f\rz' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.call,
                    group_id=0XDA9A559A
                )

                if flags(self.duration, 0):
                    writer.int(self.duration)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        duration_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            call=call_,
            duration=duration_
        )

class MessageActionInviteToGroupCall(TLObject, family='TypeMessageAction'):
    """
    A set of users was invited to the group call
    """

    _id = 0X502F92F7
    _group_id = 0X753B3B70

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        users: List[int]
    ):

        """
        A set of users was invited to the group call

        Args:
            call ('TypeInputGroupCall'): The group call
            users (List[int]): The invited users
        """

        self.call = call
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf7\x92/P' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0XDA9A559A
            )
            writer.vector(
                self.users,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        users_ = reader.vector(
            reader.long
        )

        return cls(
            call=call_,
            users=users_
        )

class MessageActionSetMessagesTTL(TLObject, family='TypeMessageAction'):
    """
    The Time-To-Live of messages in this chat was changed.
    """

    _id = 0X3C134D7B
    _group_id = 0X753B3B70

    def __init__(
        self,
        period: int,
        auto_setting_from: Optional[int] = None
    ):

        """
        The Time-To-Live of messages in this chat was changed.

        Args:
            period (int): New Time-To-Live of all messages sent in this chat; if 0, autodeletion was disabled.
            auto_setting_from (Optional[int], optional): If set, the chat TTL setting was set not due to a manual change by one of participants, but automatically because one of the participants has the [default TTL settings enabled](https://core.telegram.org/method/messages.setDefaultHistoryTTL). For example, when a user writes to us for the first time and we have set a default messages TTL of 1 week, this service message (with auto_setting_from=our_userid) will be emitted before our first message.
        """

        self.period = period
        self.auto_setting_from = auto_setting_from

    def to_bytes(self, boxed: bool=True):
        with Writer(b'{M\x13<' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.period)

                if flags(self.auto_setting_from, 0):
                    writer.long(self.auto_setting_from)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        period_ = reader.int()
        auto_setting_from_ = (
            reader.long()
            if flags(0) else None
        )

        return cls(
            period=period_,
            auto_setting_from=auto_setting_from_
        )

class MessageActionGroupCallScheduled(TLObject, family='TypeMessageAction'):
    """
    A group call was scheduled
    """

    _id = 0XB3A07661
    _group_id = 0X753B3B70

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        schedule_date: int
    ):

        """
        A group call was scheduled

        Args:
            call ('TypeInputGroupCall'): The group call
            schedule_date (int): When is this group call scheduled to start
        """

        self.call = call
        self.schedule_date = schedule_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'av\xa0\xb3' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0XDA9A559A
            )
            writer.int(self.schedule_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        schedule_date_ = reader.int()

        return cls(
            call=call_,
            schedule_date=schedule_date_
        )

class MessageActionSetChatTheme(TLObject, family='TypeMessageAction'):
    """
    The chat theme was changed
    """

    _id = 0XB91BBD3A
    _group_id = 0X753B3B70

    def __init__(
        self,
        theme: 'TypeChatTheme'
    ):

        """
        The chat theme was changed

        Args:
            theme ('TypeChatTheme'): ...
        """

        self.theme = theme

    def to_bytes(self, boxed: bool=True):
        with Writer(b':\xbd\x1b\xb9' if boxed else b'') as writer:
            writer.object(
                self.theme,
                group_id=0X7FBD8E9C
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        theme_ = reader.object(
            group_id=0X7FBD8E9C
        )

        return cls(
            theme=theme_
        )

class MessageActionChatJoinedByRequest(TLObject, family='TypeMessageAction'):
    """
    A user was accepted into the group by an admin
    """

    _id = 0XEBBCA3CB
    _group_id = 0X753B3B70


    def to_bytes(self, boxed: bool=True):
        return b'\xcb\xa3\xbc\xeb' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageActionWebViewDataSentMe(TLObject, family='TypeMessageAction'):
    """
    Data from an opened [reply keyboard bot mini app](https://core.telegram.org/api/bots/webapps) was relayed to the bot that owns it (bot side service message).
    """

    _id = 0X47DD8079
    _group_id = 0X753B3B70

    def __init__(
        self,
        text: str,
        data: str
    ):

        """
        Data from an opened [reply keyboard bot mini app](https://core.telegram.org/api/bots/webapps) was relayed to the bot that owns it (bot side service message).

        Args:
            text (str): Text of the [keyboardButtonSimpleWebView](https://core.telegram.org/constructor/keyboardButtonSimpleWebView) that was pressed to open the web app.
            data (str): Relayed data.
        """

        self.text = text
        self.data = data

    def to_bytes(self, boxed: bool=True):
        with Writer(b'y\x80\xddG' if boxed else b'') as writer:
            writer.string(self.text)
            writer.string(self.data)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        data_ = reader.string()

        return cls(
            text=text_,
            data=data_
        )

class MessageActionWebViewDataSent(TLObject, family='TypeMessageAction'):
    """
    Data from an opened [reply keyboard bot mini app](https://core.telegram.org/api/bots/webapps) was relayed to the bot that owns it (user side service message).
    """

    _id = 0XB4C38CB5
    _group_id = 0X753B3B70

    def __init__(
        self,
        text: str
    ):

        """
        Data from an opened [reply keyboard bot mini app](https://core.telegram.org/api/bots/webapps) was relayed to the bot that owns it (user side service message).

        Args:
            text (str): Text of the [keyboardButtonSimpleWebView](https://core.telegram.org/constructor/keyboardButtonSimpleWebView) that was pressed to open the web app.
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5\x8c\xc3\xb4' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class MessageActionGiftPremium(TLObject, family='TypeMessageAction'):
    """
    Info about a gifted Telegram Premium subscription
    """

    _id = 0X6C6274FA
    _group_id = 0X753B3B70

    def __init__(
        self,
        currency: str,
        amount: int,
        months: int,
        crypto_currency: Optional[str] = None,
        crypto_amount: Optional[int] = None,
        message: Optional['TypeTextWithEntities'] = None
    ):

        """
        Info about a gifted Telegram Premium subscription

        Args:
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Price of the gift in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            months (int): Duration of the gifted Telegram Premium subscription
            crypto_currency (Optional[str], optional): If the gift was bought using a cryptocurrency, the cryptocurrency name.
            crypto_amount (Optional[int], optional): If the gift was bought using a cryptocurrency, price of the gift in the smallest units of a cryptocurrency.
            message (Optional['TypeTextWithEntities'], optional): Message attached with the gift
        """

        self.currency = currency
        self.amount = amount
        self.months = months
        self.crypto_currency = crypto_currency
        self.crypto_amount = crypto_amount
        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfatbl' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.currency)
                writer.long(self.amount)
                writer.int(self.months)

                if flags(self.crypto_currency, 0):
                    writer.string(self.crypto_currency)

                if flags(self.crypto_amount, 0):
                    writer.long(self.crypto_amount)

                if flags(self.message, 1):
                    writer.object(
                        self.message,
                        group_id=0X5D96896
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        currency_ = reader.string()
        amount_ = reader.long()
        months_ = reader.int()
        crypto_currency_ = (
            reader.string()
            if flags(0) else None
        )

        crypto_amount_ = (
            reader.long()
            if flags(0) else None
        )

        message_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(1) else None
        )

        return cls(
            currency=currency_,
            amount=amount_,
            months=months_,
            crypto_currency=crypto_currency_,
            crypto_amount=crypto_amount_,
            message=message_
        )

class MessageActionTopicCreate(TLObject, family='TypeMessageAction'):
    """
    A [forum topic](https://core.telegram.org/api/forum#forum-topics) was created.
    """

    _id = 0XD999256
    _group_id = 0X753B3B70

    def __init__(
        self,
        title: str,
        icon_color: int,
        icon_emoji_id: Optional[int] = None
    ):

        """
        A [forum topic](https://core.telegram.org/api/forum#forum-topics) was created.

        Args:
            title (str): Topic name.
            icon_color (int): If no custom emoji icon is specified, specifies the color of the fallback topic icon (RGB), one of 0x6FB9F0, 0xFFD67E, 0xCB86DB, 0x8EEE98, 0xFF93B2, or 0xFB6F5F.
            icon_emoji_id (Optional[int], optional): ID of the [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon.
        """

        self.title = title
        self.icon_color = icon_color
        self.icon_emoji_id = icon_emoji_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'V\x92\x99\r' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.title)
                writer.int(self.icon_color)

                if flags(self.icon_emoji_id, 0):
                    writer.long(self.icon_emoji_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        icon_color_ = reader.int()
        icon_emoji_id_ = (
            reader.long()
            if flags(0) else None
        )

        return cls(
            title=title_,
            icon_color=icon_color_,
            icon_emoji_id=icon_emoji_id_
        )

class MessageActionTopicEdit(TLObject, family='TypeMessageAction'):
    """
    [Forum topic](https://core.telegram.org/api/forum#forum-topics) information was edited.
    """

    _id = 0XC0944820
    _group_id = 0X753B3B70

    def __init__(
        self,
        title: Optional[str] = None,
        icon_emoji_id: Optional[int] = None,
        closed: bool = False,
        hidden: bool = False
    ):

        """
        [Forum topic](https://core.telegram.org/api/forum#forum-topics) information was edited.

        Args:
            title (Optional[str], optional): New topic title.
            icon_emoji_id (Optional[int], optional): ID of the new [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon, or if it was removed.
            closed (bool, optional): Whether the topic was opened or closed.
            hidden (bool, optional): Whether the topic was hidden or unhidden (only valid for the "General" topic, id=1).
        """

        self.title = title
        self.icon_emoji_id = icon_emoji_id
        self.closed = closed
        self.hidden = hidden

    def to_bytes(self, boxed: bool=True):
        with Writer(b' H\x94\xc0' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.icon_emoji_id, 1):
                    writer.long(self.icon_emoji_id)

                if flags(self.closed, 2):
                    writer.object(
                        self.closed,
                        group_id=0X43B904E1
                    )

                if flags(self.hidden, 3):
                    writer.object(
                        self.hidden,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = (
            reader.string()
            if flags(0) else None
        )

        icon_emoji_id_ = (
            reader.long()
            if flags(1) else None
        )

        closed_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(2) else None
        )

        hidden_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(3) else None
        )

        return cls(
            title=title_,
            icon_emoji_id=icon_emoji_id_,
            closed=closed_,
            hidden=hidden_
        )

class MessageActionSuggestProfilePhoto(TLObject, family='TypeMessageAction'):
    """
    A new profile picture was suggested using [photos.uploadContactProfilePhoto](https://core.telegram.org/method/photos.uploadContactProfilePhoto).
    """

    _id = 0X57DE635E
    _group_id = 0X753B3B70

    def __init__(
        self,
        photo: 'TypePhoto'
    ):

        """
        A new profile picture was suggested using [photos.uploadContactProfilePhoto](https://core.telegram.org/method/photos.uploadContactProfilePhoto).

        Args:
            photo ('TypePhoto'): The photo that the user suggested we set as profile picture.
        """

        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'^c\xdeW' if boxed else b'') as writer:
            writer.object(
                self.photo,
                group_id=0XDDAD9CAC
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        photo_ = reader.object(
            group_id=0XDDAD9CAC
        )

        return cls(
            photo=photo_
        )

class MessageActionRequestedPeer(TLObject, family='TypeMessageAction'):
    """
    Contains info about one or more peers that the we (the user) shared with the bot after clicking on a [keyboardButtonRequestPeer](https://core.telegram.org/constructor/keyboardButtonRequestPeer) button (service message sent by the user).
    """

    _id = 0X31518E9B
    _group_id = 0X753B3B70

    def __init__(
        self,
        button_id: int,
        peers: List['TypePeer']
    ):

        """
        Contains info about one or more peers that the we (the user) shared with the bot after clicking on a [keyboardButtonRequestPeer](https://core.telegram.org/constructor/keyboardButtonRequestPeer) button (service message sent by the user).

        Args:
            button_id (int): button_id contained in the [keyboardButtonRequestPeer](https://core.telegram.org/constructor/keyboardButtonRequestPeer)
            peers (List['TypePeer']): The shared peers
        """

        self.button_id = button_id
        self.peers = peers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9b\x8eQ1' if boxed else b'') as writer:
            writer.int(self.button_id)
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0XB4DECBCA
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        button_id_ = reader.int()
        peers_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        return cls(
            button_id=button_id_,
            peers=peers_
        )

class MessageActionSetChatWallPaper(TLObject, family='TypeMessageAction'):
    """
    The [wallpaper](https://core.telegram.org/api/wallpapers) of the current chat was changed.
    """

    _id = 0X5060A3F4
    _group_id = 0X753B3B70

    def __init__(
        self,
        wallpaper: 'TypeWallPaper',
        same: bool = False,
        for_both: bool = False
    ):

        """
        The [wallpaper](https://core.telegram.org/api/wallpapers) of the current chat was changed.

        Args:
            wallpaper ('TypeWallPaper'): New [wallpaper](https://core.telegram.org/api/wallpapers)
            same (bool, optional): If set, indicates the user applied a [wallpaper](https://core.telegram.org/api/wallpapers) previously sent by the other user in a [messageActionSetChatWallPaper](https://core.telegram.org/constructor/messageActionSetChatWallPaper) message.
            for_both (bool, optional): If set, indicates the wallpaper was forcefully applied for both sides, without explicit confirmation from the other side. If the message is incoming, and we did not like the new wallpaper the other user has chosen for us, we can re-set our previous wallpaper just on our side, by invoking [messages.setChatWallPaper](https://core.telegram.org/method/messages.setChatWallPaper), providing only the revert flag (and obviously the peer parameter).
        """

        self.wallpaper = wallpaper
        self.same = same
        self.for_both = for_both

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf4\xa3`P' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.same, 0)
                flags(self.for_both, 1)
                writer.object(
                    self.wallpaper,
                    group_id=0XC6E3E0E2
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        wallpaper_ = reader.object(
            group_id=0XC6E3E0E2
        )

        return cls(
            wallpaper=wallpaper_,
            same=flags(0),
            for_both=flags(1)
        )

class MessageActionGiftCode(TLObject, family='TypeMessageAction'):
    """
    Contains a [Telegram Premium giftcode link](https://core.telegram.org/api/links#premium-giftcode-links).
    """

    _id = 0X56D03994
    _group_id = 0X753B3B70

    def __init__(
        self,
        months: int,
        slug: str,
        via_giveaway: bool = False,
        unclaimed: bool = False,
        boost_peer: Optional['TypePeer'] = None,
        currency: Optional[str] = None,
        amount: Optional[int] = None,
        crypto_currency: Optional[str] = None,
        crypto_amount: Optional[int] = None,
        message: Optional['TypeTextWithEntities'] = None
    ):

        """
        Contains a [Telegram Premium giftcode link](https://core.telegram.org/api/links#premium-giftcode-links).

        Args:
            months (int): Duration in months of the gifted [Telegram Premium subscription](https://core.telegram.org/api/premium).
            slug (str): Slug of the [Telegram Premium giftcode link](https://core.telegram.org/api/links#premium-giftcode-links)
            via_giveaway (bool, optional): If set, this gift code was received from a [giveaway](https://core.telegram.org/api/giveaways) started by a channel/supergroup we're subscribed to.
            unclaimed (bool, optional): If set, the link was not [redeemed](https://core.telegram.org/api/links#premium-giftcode-links) yet.
            boost_peer (Optional['TypePeer'], optional): Identifier of the channel/supergroup that created the gift code [either directly or through a giveaway](https://core.telegram.org/api/giveaways): if we import this giftcode link, we will also automatically [boost](https://core.telegram.org/api/boost) this channel/supergroup.
            currency (Optional[str], optional): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (Optional[int], optional): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            crypto_currency (Optional[str], optional): If set, the gift was made using the specified cryptocurrency.
            crypto_amount (Optional[int], optional): If crypto_currency is set, contains the paid amount, in the smallest units of the cryptocurrency.
            message (Optional['TypeTextWithEntities'], optional): Message attached with the gift
        """

        self.months = months
        self.slug = slug
        self.via_giveaway = via_giveaway
        self.unclaimed = unclaimed
        self.boost_peer = boost_peer
        self.currency = currency
        self.amount = amount
        self.crypto_currency = crypto_currency
        self.crypto_amount = crypto_amount
        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x949\xd0V' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.via_giveaway, 0)
                flags(self.unclaimed, 5)

                if flags(self.boost_peer, 1):
                    writer.object(
                        self.boost_peer,
                        group_id=0XB4DECBCA
                    )
                writer.int(self.months)
                writer.string(self.slug)

                if flags(self.currency, 2):
                    writer.string(self.currency)

                if flags(self.amount, 2):
                    writer.long(self.amount)

                if flags(self.crypto_currency, 3):
                    writer.string(self.crypto_currency)

                if flags(self.crypto_amount, 3):
                    writer.long(self.crypto_amount)

                if flags(self.message, 4):
                    writer.object(
                        self.message,
                        group_id=0X5D96896
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        boost_peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(1) else None
        )

        months_ = reader.int()
        slug_ = reader.string()
        currency_ = (
            reader.string()
            if flags(2) else None
        )

        amount_ = (
            reader.long()
            if flags(2) else None
        )

        crypto_currency_ = (
            reader.string()
            if flags(3) else None
        )

        crypto_amount_ = (
            reader.long()
            if flags(3) else None
        )

        message_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(4) else None
        )

        return cls(
            months=months_,
            slug=slug_,
            via_giveaway=flags(0),
            unclaimed=flags(5),
            boost_peer=boost_peer_,
            currency=currency_,
            amount=amount_,
            crypto_currency=crypto_currency_,
            crypto_amount=crypto_amount_,
            message=message_
        )

class MessageActionGiveawayLaunch(TLObject, family='TypeMessageAction'):
    """
    A [giveaway](https://core.telegram.org/api/giveaways) was started.
    """

    _id = 0XA80F51E4
    _group_id = 0X753B3B70

    def __init__(
        self,
        stars: Optional[int] = None
    ):

        """
        A [giveaway](https://core.telegram.org/api/giveaways) was started.

        Args:
            stars (Optional[int], optional): For [Telegram Star giveaways](https://core.telegram.org/api/stars#star-giveaways), the total number of Telegram Stars being given away.
        """

        self.stars = stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe4Q\x0f\xa8' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.stars, 0):
                    writer.long(self.stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = (
            reader.long()
            if flags(0) else None
        )

        return cls(
            stars=stars_
        )

class MessageActionGiveawayResults(TLObject, family='TypeMessageAction'):
    """
    A [giveaway](https://core.telegram.org/api/giveaways) has ended.
    """

    _id = 0X87E2F155
    _group_id = 0X753B3B70

    def __init__(
        self,
        winners_count: int,
        unclaimed_count: int,
        stars: bool = False
    ):

        """
        A [giveaway](https://core.telegram.org/api/giveaways) has ended.

        Args:
            winners_count (int): Number of winners in the giveaway
            unclaimed_count (int): Number of undistributed prizes
            stars (bool, optional): If set, this is a [Telegram Star giveaway](https://core.telegram.org/api/stars#star-giveaways)
        """

        self.winners_count = winners_count
        self.unclaimed_count = unclaimed_count
        self.stars = stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'U\xf1\xe2\x87' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.stars, 0)
                writer.int(self.winners_count)
                writer.int(self.unclaimed_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        winners_count_ = reader.int()
        unclaimed_count_ = reader.int()

        return cls(
            winners_count=winners_count_,
            unclaimed_count=unclaimed_count_,
            stars=flags(0)
        )

class MessageActionBoostApply(TLObject, family='TypeMessageAction'):
    """
    Some [boosts](https://core.telegram.org/api/boost) were applied to the channel or supergroup.
    """

    _id = 0XCC02AA6D
    _group_id = 0X753B3B70

    def __init__(
        self,
        boosts: int
    ):

        """
        Some [boosts](https://core.telegram.org/api/boost) were applied to the channel or supergroup.

        Args:
            boosts (int): Number of applied [boosts](https://core.telegram.org/api/boost).
        """

        self.boosts = boosts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'm\xaa\x02\xcc' if boxed else b'') as writer:
            writer.int(self.boosts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        boosts_ = reader.int()

        return cls(
            boosts=boosts_
        )

class MessageActionRequestedPeerSentMe(TLObject, family='TypeMessageAction'):
    """
    Contains info about one or more peers that the a user shared with the me (the bot) after clicking on a [keyboardButtonRequestPeer](https://core.telegram.org/constructor/keyboardButtonRequestPeer) button (service message received by the bot).
    """

    _id = 0X93B31848
    _group_id = 0X753B3B70

    def __init__(
        self,
        button_id: int,
        peers: List['TypeRequestedPeer']
    ):

        """
        Contains info about one or more peers that the a user shared with the me (the bot) after clicking on a [keyboardButtonRequestPeer](https://core.telegram.org/constructor/keyboardButtonRequestPeer) button (service message received by the bot).

        Args:
            button_id (int): button_id contained in the [keyboardButtonRequestPeer](https://core.telegram.org/constructor/keyboardButtonRequestPeer)
            peers (List['TypeRequestedPeer']): Info about the shared peers.
        """

        self.button_id = button_id
        self.peers = peers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'H\x18\xb3\x93' if boxed else b'') as writer:
            writer.int(self.button_id)
            writer.vector(
                self.peers,
                lambda value: writer.object(
                    value,
                    group_id=0X31339646
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        button_id_ = reader.int()
        peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X31339646
            )
        )

        return cls(
            button_id=button_id_,
            peers=peers_
        )

class MessageActionPaymentRefunded(TLObject, family='TypeMessageAction'):
    """
    Describes a payment refund (service message received by both users and bots).
    """

    _id = 0X41B3E202
    _group_id = 0X753B3B70

    def __init__(
        self,
        peer: 'TypePeer',
        currency: str,
        total_amount: int,
        charge: 'TypePaymentCharge',
        payload: Optional[bytes] = None
    ):

        """
        Describes a payment refund (service message received by both users and bots).

        Args:
            peer ('TypePeer'): Identifier of the peer that returned the funds.
            currency (str): Currency, XTR for Telegram Stars.
            total_amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            charge ('TypePaymentCharge'): Provider payment identifier
            payload (Optional[bytes], optional): Bot specified invoice payload (only received by bots).
        """

        self.peer = peer
        self.currency = currency
        self.total_amount = total_amount
        self.charge = charge
        self.payload = payload

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x02\xe2\xb3A' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.string(self.currency)
                writer.long(self.total_amount)

                if flags(self.payload, 0):
                    writer.bytes(self.payload)
                writer.object(
                    self.charge,
                    group_id=0XCF73DA8F
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        currency_ = reader.string()
        total_amount_ = reader.long()
        payload_ = (
            reader.bytes()
            if flags(0) else None
        )

        charge_ = reader.object(
            group_id=0XCF73DA8F
        )

        return cls(
            peer=peer_,
            currency=currency_,
            total_amount=total_amount_,
            charge=charge_,
            payload=payload_
        )

class MessageActionGiftStars(TLObject, family='TypeMessageAction'):
    """
    You gifted or were gifted some [Telegram Stars](https://core.telegram.org/api/stars).
    """

    _id = 0X45D5B021
    _group_id = 0X753B3B70

    def __init__(
        self,
        currency: str,
        amount: int,
        stars: int,
        crypto_currency: Optional[str] = None,
        crypto_amount: Optional[int] = None,
        transaction_id: Optional[str] = None
    ):

        """
        You gifted or were gifted some [Telegram Stars](https://core.telegram.org/api/stars).

        Args:
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Price of the gift in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            stars (int): Amount of gifted stars
            crypto_currency (Optional[str], optional): If the gift was bought using a cryptocurrency, the cryptocurrency name.
            crypto_amount (Optional[int], optional): If the gift was bought using a cryptocurrency, price of the gift in the smallest units of a cryptocurrency.
            transaction_id (Optional[str], optional): Identifier of the transaction, only visible to the receiver of the gift.
        """

        self.currency = currency
        self.amount = amount
        self.stars = stars
        self.crypto_currency = crypto_currency
        self.crypto_amount = crypto_amount
        self.transaction_id = transaction_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'!\xb0\xd5E' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.currency)
                writer.long(self.amount)
                writer.long(self.stars)

                if flags(self.crypto_currency, 0):
                    writer.string(self.crypto_currency)

                if flags(self.crypto_amount, 0):
                    writer.long(self.crypto_amount)

                if flags(self.transaction_id, 1):
                    writer.string(self.transaction_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        currency_ = reader.string()
        amount_ = reader.long()
        stars_ = reader.long()
        crypto_currency_ = (
            reader.string()
            if flags(0) else None
        )

        crypto_amount_ = (
            reader.long()
            if flags(0) else None
        )

        transaction_id_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            currency=currency_,
            amount=amount_,
            stars=stars_,
            crypto_currency=crypto_currency_,
            crypto_amount=crypto_amount_,
            transaction_id=transaction_id_
        )

class MessageActionPrizeStars(TLObject, family='TypeMessageAction'):
    """
    You won some [Telegram Stars](https://core.telegram.org/api/stars) in a [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways).
    """

    _id = 0XB00C47A2
    _group_id = 0X753B3B70

    def __init__(
        self,
        stars: int,
        transaction_id: str,
        boost_peer: 'TypePeer',
        giveaway_msg_id: int,
        unclaimed: bool = False
    ):

        """
        You won some [Telegram Stars](https://core.telegram.org/api/stars) in a [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways).

        Args:
            stars (int): The number of Telegram Stars you won
            transaction_id (str): ID of the telegram star transaction.
            boost_peer ('TypePeer'): Identifier of the peer that was automatically boosted by the winners of the giveaway.
            giveaway_msg_id (int): ID of the message containing the [messageMediaGiveaway](https://core.telegram.org/constructor/messageMediaGiveaway)
            unclaimed (bool, optional): If set, this indicates the reverse transaction that refunds the remaining stars to the creator of a giveaway if, when the giveaway ends, the number of members in the channel is smaller than the number of winners in the giveaway.
        """

        self.stars = stars
        self.transaction_id = transaction_id
        self.boost_peer = boost_peer
        self.giveaway_msg_id = giveaway_msg_id
        self.unclaimed = unclaimed

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa2G\x0c\xb0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.unclaimed, 0)
                writer.long(self.stars)
                writer.string(self.transaction_id)
                writer.object(
                    self.boost_peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.giveaway_msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = reader.long()
        transaction_id_ = reader.string()
        boost_peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        giveaway_msg_id_ = reader.int()

        return cls(
            stars=stars_,
            transaction_id=transaction_id_,
            boost_peer=boost_peer_,
            giveaway_msg_id=giveaway_msg_id_,
            unclaimed=flags(0)
        )

class MessageActionStarGift(TLObject, family='TypeMessageAction'):
    """
    You received a [gift, see here](https://core.telegram.org/api/gifts) for more info.
    """

    _id = 0XF24DE7FA
    _group_id = 0X753B3B70

    def __init__(
        self,
        gift: 'TypeStarGift',
        name_hidden: bool = False,
        saved: bool = False,
        converted: bool = False,
        upgraded: bool = False,
        refunded: bool = False,
        can_upgrade: bool = False,
        prepaid_upgrade: bool = False,
        upgrade_separate: bool = False,
        message: Optional['TypeTextWithEntities'] = None,
        convert_stars: Optional[int] = None,
        upgrade_msg_id: Optional[int] = None,
        upgrade_stars: Optional[int] = None,
        from_id: Optional['TypePeer'] = None,
        peer: Optional['TypePeer'] = None,
        saved_id: Optional[int] = None,
        prepaid_upgrade_hash: Optional[str] = None,
        gift_msg_id: Optional[int] = None
    ):

        """
        You received a [gift, see here](https://core.telegram.org/api/gifts) for more info.

        Args:
            gift ('TypeStarGift'): Info about the gift
            name_hidden (bool, optional): If set, the name of the sender of the gift will be hidden if the destination user decides to display the gift on their profile
            saved (bool, optional): Whether this gift was added to the destination user's profile (may be toggled using [payments.saveStarGift](https://core.telegram.org/method/payments.saveStarGift) and fetched using [payments.getUserStarGifts](https://core.telegram.org/method/payments.getUserStarGifts))
            converted (bool, optional): Whether this gift was converted to [Telegram Stars](https://core.telegram.org/api/stars) and cannot be displayed on the profile anymore.
            upgraded (bool, optional): ...
            refunded (bool, optional): ...
            can_upgrade (bool, optional): ...
            prepaid_upgrade (bool, optional): ...
            upgrade_separate (bool, optional): ...
            message (Optional['TypeTextWithEntities'], optional): Additional message from the sender of the gift
            convert_stars (Optional[int], optional): The receiver of this gift may convert it to this many Telegram Stars, instead of displaying it on their profile page. convert_stars will be equal to stars only if the gift was bought using recently bought Telegram Stars, otherwise it will be less than stars.
            upgrade_msg_id (Optional[int], optional): ...
            upgrade_stars (Optional[int], optional): ...
            from_id (Optional['TypePeer'], optional): ...
            peer (Optional['TypePeer'], optional): ...
            saved_id (Optional[int], optional): ...
            prepaid_upgrade_hash (Optional[str], optional): ...
            gift_msg_id (Optional[int], optional): ...
        """

        self.gift = gift
        self.name_hidden = name_hidden
        self.saved = saved
        self.converted = converted
        self.upgraded = upgraded
        self.refunded = refunded
        self.can_upgrade = can_upgrade
        self.prepaid_upgrade = prepaid_upgrade
        self.upgrade_separate = upgrade_separate
        self.message = message
        self.convert_stars = convert_stars
        self.upgrade_msg_id = upgrade_msg_id
        self.upgrade_stars = upgrade_stars
        self.from_id = from_id
        self.peer = peer
        self.saved_id = saved_id
        self.prepaid_upgrade_hash = prepaid_upgrade_hash
        self.gift_msg_id = gift_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfa\xe7M\xf2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.name_hidden, 0)
                flags(self.saved, 2)
                flags(self.converted, 3)
                flags(self.upgraded, 5)
                flags(self.refunded, 9)
                flags(self.can_upgrade, 10)
                flags(self.prepaid_upgrade, 13)
                flags(self.upgrade_separate, 16)
                writer.object(
                    self.gift,
                    group_id=0X87440C7B
                )

                if flags(self.message, 1):
                    writer.object(
                        self.message,
                        group_id=0X5D96896
                    )

                if flags(self.convert_stars, 4):
                    writer.long(self.convert_stars)

                if flags(self.upgrade_msg_id, 5):
                    writer.int(self.upgrade_msg_id)

                if flags(self.upgrade_stars, 8):
                    writer.long(self.upgrade_stars)

                if flags(self.from_id, 11):
                    writer.object(
                        self.from_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.peer, 12):
                    writer.object(
                        self.peer,
                        group_id=0XB4DECBCA
                    )

                if flags(self.saved_id, 12):
                    writer.long(self.saved_id)

                if flags(self.prepaid_upgrade_hash, 14):
                    writer.string(self.prepaid_upgrade_hash)

                if flags(self.gift_msg_id, 15):
                    writer.int(self.gift_msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        gift_ = reader.object(
            group_id=0X87440C7B
        )

        message_ = (
            reader.object(
                group_id=0X5D96896
            )
            if flags(1) else None
        )

        convert_stars_ = (
            reader.long()
            if flags(4) else None
        )

        upgrade_msg_id_ = (
            reader.int()
            if flags(5) else None
        )

        upgrade_stars_ = (
            reader.long()
            if flags(8) else None
        )

        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(11) else None
        )

        peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(12) else None
        )

        saved_id_ = (
            reader.long()
            if flags(12) else None
        )

        prepaid_upgrade_hash_ = (
            reader.string()
            if flags(14) else None
        )

        gift_msg_id_ = (
            reader.int()
            if flags(15) else None
        )

        return cls(
            gift=gift_,
            name_hidden=flags(0),
            saved=flags(2),
            converted=flags(3),
            upgraded=flags(5),
            refunded=flags(9),
            can_upgrade=flags(10),
            prepaid_upgrade=flags(13),
            upgrade_separate=flags(16),
            message=message_,
            convert_stars=convert_stars_,
            upgrade_msg_id=upgrade_msg_id_,
            upgrade_stars=upgrade_stars_,
            from_id=from_id_,
            peer=peer_,
            saved_id=saved_id_,
            prepaid_upgrade_hash=prepaid_upgrade_hash_,
            gift_msg_id=gift_msg_id_
        )

class MessageActionStarGiftUnique(TLObject, family='TypeMessageAction'):
    _id = 0X34F762F3
    _group_id = 0X753B3B70

    def __init__(
        self,
        gift: 'TypeStarGift',
        upgrade: bool = False,
        transferred: bool = False,
        saved: bool = False,
        refunded: bool = False,
        prepaid_upgrade: bool = False,
        can_export_at: Optional[int] = None,
        transfer_stars: Optional[int] = None,
        from_id: Optional['TypePeer'] = None,
        peer: Optional['TypePeer'] = None,
        saved_id: Optional[int] = None,
        resale_amount: Optional['TypeStarsAmount'] = None,
        can_transfer_at: Optional[int] = None,
        can_resell_at: Optional[int] = None
    ):

        self.gift = gift
        self.upgrade = upgrade
        self.transferred = transferred
        self.saved = saved
        self.refunded = refunded
        self.prepaid_upgrade = prepaid_upgrade
        self.can_export_at = can_export_at
        self.transfer_stars = transfer_stars
        self.from_id = from_id
        self.peer = peer
        self.saved_id = saved_id
        self.resale_amount = resale_amount
        self.can_transfer_at = can_transfer_at
        self.can_resell_at = can_resell_at

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf3b\xf74' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.upgrade, 0)
                flags(self.transferred, 1)
                flags(self.saved, 2)
                flags(self.refunded, 5)
                flags(self.prepaid_upgrade, 11)
                writer.object(
                    self.gift,
                    group_id=0X87440C7B
                )

                if flags(self.can_export_at, 3):
                    writer.int(self.can_export_at)

                if flags(self.transfer_stars, 4):
                    writer.long(self.transfer_stars)

                if flags(self.from_id, 6):
                    writer.object(
                        self.from_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.peer, 7):
                    writer.object(
                        self.peer,
                        group_id=0XB4DECBCA
                    )

                if flags(self.saved_id, 7):
                    writer.long(self.saved_id)

                if flags(self.resale_amount, 8):
                    writer.object(
                        self.resale_amount,
                        group_id=0XC3D62A83
                    )

                if flags(self.can_transfer_at, 9):
                    writer.int(self.can_transfer_at)

                if flags(self.can_resell_at, 10):
                    writer.int(self.can_resell_at)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        gift_ = reader.object(
            group_id=0X87440C7B
        )

        can_export_at_ = (
            reader.int()
            if flags(3) else None
        )

        transfer_stars_ = (
            reader.long()
            if flags(4) else None
        )

        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(6) else None
        )

        peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(7) else None
        )

        saved_id_ = (
            reader.long()
            if flags(7) else None
        )

        resale_amount_ = (
            reader.object(
                group_id=0XC3D62A83
            )
            if flags(8) else None
        )

        can_transfer_at_ = (
            reader.int()
            if flags(9) else None
        )

        can_resell_at_ = (
            reader.int()
            if flags(10) else None
        )

        return cls(
            gift=gift_,
            upgrade=flags(0),
            transferred=flags(1),
            saved=flags(2),
            refunded=flags(5),
            prepaid_upgrade=flags(11),
            can_export_at=can_export_at_,
            transfer_stars=transfer_stars_,
            from_id=from_id_,
            peer=peer_,
            saved_id=saved_id_,
            resale_amount=resale_amount_,
            can_transfer_at=can_transfer_at_,
            can_resell_at=can_resell_at_
        )

class MessageActionPaidMessagesRefunded(TLObject, family='TypeMessageAction'):
    _id = 0XAC1F1FCD
    _group_id = 0X753B3B70

    def __init__(
        self,
        count: int,
        stars: int
    ):

        self.count = count
        self.stars = stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcd\x1f\x1f\xac' if boxed else b'') as writer:
            writer.int(self.count)
            writer.long(self.stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        stars_ = reader.long()

        return cls(
            count=count_,
            stars=stars_
        )

class MessageActionPaidMessagesPrice(TLObject, family='TypeMessageAction'):
    _id = 0X84B88578
    _group_id = 0X753B3B70

    def __init__(
        self,
        stars: int,
        broadcast_messages_allowed: bool = False
    ):

        self.stars = stars
        self.broadcast_messages_allowed = broadcast_messages_allowed

    def to_bytes(self, boxed: bool=True):
        with Writer(b'x\x85\xb8\x84' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.broadcast_messages_allowed, 0)
                writer.long(self.stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = reader.long()

        return cls(
            stars=stars_,
            broadcast_messages_allowed=flags(0)
        )

class MessageActionConferenceCall(TLObject, family='TypeMessageAction'):
    _id = 0X2FFE2F7A
    _group_id = 0X753B3B70

    def __init__(
        self,
        call_id: int,
        missed: bool = False,
        active: bool = False,
        video: bool = False,
        duration: Optional[int] = None,
        other_participants: Optional[List['TypePeer']] = None
    ):

        self.call_id = call_id
        self.missed = missed
        self.active = active
        self.video = video
        self.duration = duration
        self.other_participants = other_participants

    def to_bytes(self, boxed: bool=True):
        with Writer(b'z/\xfe/' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.missed, 0)
                flags(self.active, 1)
                flags(self.video, 4)
                writer.long(self.call_id)

                if flags(self.duration, 2):
                    writer.int(self.duration)

                if flags(self.other_participants, 3):
                    writer.vector(
                        self.other_participants,
                        lambda value: writer.object(
                            value,
                            group_id=0XB4DECBCA
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        call_id_ = reader.long()
        duration_ = (
            reader.int()
            if flags(2) else None
        )

        other_participants_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XB4DECBCA
                )
            )
            if flags(3) else None
        )

        return cls(
            call_id=call_id_,
            missed=flags(0),
            active=flags(1),
            video=flags(4),
            duration=duration_,
            other_participants=other_participants_
        )

class MessageActionTodoCompletions(TLObject, family='TypeMessageAction'):
    _id = 0XCC7C5C89
    _group_id = 0X753B3B70

    def __init__(
        self,
        completed: List[int],
        incompleted: List[int]
    ):

        self.completed = completed
        self.incompleted = incompleted

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x89\\|\xcc' if boxed else b'') as writer:
            writer.vector(
                self.completed,
                writer.int
            )
            writer.vector(
                self.incompleted,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        completed_ = reader.vector(
            reader.int
        )

        incompleted_ = reader.vector(
            reader.int
        )

        return cls(
            completed=completed_,
            incompleted=incompleted_
        )

class MessageActionTodoAppendTasks(TLObject, family='TypeMessageAction'):
    _id = 0XC7EDBC83
    _group_id = 0X753B3B70

    def __init__(
        self,
        list: List['TypeTodoItem']
    ):

        self.list = list

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x83\xbc\xed\xc7' if boxed else b'') as writer:
            writer.vector(
                self.list,
                lambda value: writer.object(
                    value,
                    group_id=0X9B82B3C5
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        list_ = reader.vector(
            lambda: reader.object(
                group_id=0X9B82B3C5
            )
        )

        return cls(
            list=list_
        )

class MessageActionSuggestedPostApproval(TLObject, family='TypeMessageAction'):
    _id = 0XEE7A1596
    _group_id = 0X753B3B70

    def __init__(
        self,
        rejected: bool = False,
        balance_too_low: bool = False,
        reject_comment: Optional[str] = None,
        schedule_date: Optional[int] = None,
        price: Optional['TypeStarsAmount'] = None
    ):

        self.rejected = rejected
        self.balance_too_low = balance_too_low
        self.reject_comment = reject_comment
        self.schedule_date = schedule_date
        self.price = price

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x96\x15z\xee' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.rejected, 0)
                flags(self.balance_too_low, 1)

                if flags(self.reject_comment, 2):
                    writer.string(self.reject_comment)

                if flags(self.schedule_date, 3):
                    writer.int(self.schedule_date)

                if flags(self.price, 4):
                    writer.object(
                        self.price,
                        group_id=0XC3D62A83
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        reject_comment_ = (
            reader.string()
            if flags(2) else None
        )

        schedule_date_ = (
            reader.int()
            if flags(3) else None
        )

        price_ = (
            reader.object(
                group_id=0XC3D62A83
            )
            if flags(4) else None
        )

        return cls(
            rejected=flags(0),
            balance_too_low=flags(1),
            reject_comment=reject_comment_,
            schedule_date=schedule_date_,
            price=price_
        )

class MessageActionSuggestedPostSuccess(TLObject, family='TypeMessageAction'):
    _id = 0X95DDCF69
    _group_id = 0X753B3B70

    def __init__(
        self,
        price: 'TypeStarsAmount'
    ):

        self.price = price

    def to_bytes(self, boxed: bool=True):
        with Writer(b'i\xcf\xdd\x95' if boxed else b'') as writer:
            writer.object(
                self.price,
                group_id=0XC3D62A83
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        price_ = reader.object(
            group_id=0XC3D62A83
        )

        return cls(
            price=price_
        )

class MessageActionSuggestedPostRefund(TLObject, family='TypeMessageAction'):
    _id = 0X69F916F8
    _group_id = 0X753B3B70

    def __init__(
        self,
        payer_initiated: bool = False
    ):

        self.payer_initiated = payer_initiated

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8\x16\xf9i' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.payer_initiated, 0)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            payer_initiated=flags(0)
        )

class MessageActionGiftTon(TLObject, family='TypeMessageAction'):
    _id = 0XA8A3C699
    _group_id = 0X753B3B70

    def __init__(
        self,
        currency: str,
        amount: int,
        crypto_currency: str,
        crypto_amount: int,
        transaction_id: Optional[str] = None
    ):

        self.currency = currency
        self.amount = amount
        self.crypto_currency = crypto_currency
        self.crypto_amount = crypto_amount
        self.transaction_id = transaction_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99\xc6\xa3\xa8' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.currency)
                writer.long(self.amount)
                writer.string(self.crypto_currency)
                writer.long(self.crypto_amount)

                if flags(self.transaction_id, 0):
                    writer.string(self.transaction_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        currency_ = reader.string()
        amount_ = reader.long()
        crypto_currency_ = reader.string()
        crypto_amount_ = reader.long()
        transaction_id_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            currency=currency_,
            amount=amount_,
            crypto_currency=crypto_currency_,
            crypto_amount=crypto_amount_,
            transaction_id=transaction_id_
        )

TypeMessageAction = Union[
    MessageActionEmpty,
    MessageActionChatCreate,
    MessageActionChatEditTitle,
    MessageActionChatEditPhoto,
    MessageActionChatDeletePhoto,
    MessageActionChatAddUser,
    MessageActionChatDeleteUser,
    MessageActionChatJoinedByLink,
    MessageActionChannelCreate,
    MessageActionChatMigrateTo,
    MessageActionChannelMigrateFrom,
    MessageActionPinMessage,
    MessageActionHistoryClear,
    MessageActionGameScore,
    MessageActionPaymentSentMe,
    MessageActionPaymentSent,
    MessageActionPhoneCall,
    MessageActionScreenshotTaken,
    MessageActionCustomAction,
    MessageActionBotAllowed,
    MessageActionSecureValuesSentMe,
    MessageActionSecureValuesSent,
    MessageActionContactSignUp,
    MessageActionGeoProximityReached,
    MessageActionGroupCall,
    MessageActionInviteToGroupCall,
    MessageActionSetMessagesTTL,
    MessageActionGroupCallScheduled,
    MessageActionSetChatTheme,
    MessageActionChatJoinedByRequest,
    MessageActionWebViewDataSentMe,
    MessageActionWebViewDataSent,
    MessageActionGiftPremium,
    MessageActionTopicCreate,
    MessageActionTopicEdit,
    MessageActionSuggestProfilePhoto,
    MessageActionRequestedPeer,
    MessageActionSetChatWallPaper,
    MessageActionGiftCode,
    MessageActionGiveawayLaunch,
    MessageActionGiveawayResults,
    MessageActionBoostApply,
    MessageActionRequestedPeerSentMe,
    MessageActionPaymentRefunded,
    MessageActionGiftStars,
    MessageActionPrizeStars,
    MessageActionStarGift,
    MessageActionStarGiftUnique,
    MessageActionPaidMessagesRefunded,
    MessageActionPaidMessagesPrice,
    MessageActionConferenceCall,
    MessageActionTodoCompletions,
    MessageActionTodoAppendTasks,
    MessageActionSuggestedPostApproval,
    MessageActionSuggestedPostSuccess,
    MessageActionSuggestedPostRefund,
    MessageActionGiftTon
]