
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class MessagePeerVote(TLObject, family='TypeMessagePeerVote'):
    """
    How a peer voted in a poll
    """

    _id = 0XB6CC2D5C
    _group_id = 0X29FC700D

    def __init__(
        self,
        peer: 'TypePeer',
        option: bytes,
        date: int
    ):

        """
        How a peer voted in a poll

        Args:
            peer ('TypePeer'): Peer ID
            option (bytes): The option chosen by the peer
            date (int): When did the peer cast the vote
        """

        self.peer = peer
        self.option = option
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\-\xcc\xb6' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.bytes(self.option)
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        option_ = reader.bytes()
        date_ = reader.int()

        return cls(
            peer=peer_,
            option=option_,
            date=date_
        )

class MessagePeerVoteInputOption(TLObject, family='TypeMessagePeerVote'):
    """
    How a peer voted in a poll (reduced constructor, returned if an option was provided to [messages.getPollVotes](https://core.telegram.org/method/messages.getPollVotes))
    """

    _id = 0X74CDA504
    _group_id = 0X29FC700D

    def __init__(
        self,
        peer: 'TypePeer',
        date: int
    ):

        """
        How a peer voted in a poll (reduced constructor, returned if an option was provided to [messages.getPollVotes](https://core.telegram.org/method/messages.getPollVotes))

        Args:
            peer ('TypePeer'): The peer that voted for the queried option
            date (int): When did the peer cast the vote
        """

        self.peer = peer
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x04\xa5\xcdt' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        date_ = reader.int()

        return cls(
            peer=peer_,
            date=date_
        )

class MessagePeerVoteMultiple(TLObject, family='TypeMessagePeerVote'):
    """
    How a peer voted in a multiple-choice poll
    """

    _id = 0X4628F6E6
    _group_id = 0X29FC700D

    def __init__(
        self,
        peer: 'TypePeer',
        options: List[bytes],
        date: int
    ):

        """
        How a peer voted in a multiple-choice poll

        Args:
            peer ('TypePeer'): Peer ID
            options (List[bytes]): Options chosen by the peer
            date (int): When did the peer cast their votes
        """

        self.peer = peer
        self.options = options
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe6\xf6(F' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.vector(
                self.options,
                writer.bytes
            )
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        options_ = reader.vector(
            reader.bytes
        )

        date_ = reader.int()

        return cls(
            peer=peer_,
            options=options_,
            date=date_
        )

TypeMessagePeerVote = Union[
    MessagePeerVote,
    MessagePeerVoteInputOption,
    MessagePeerVoteMultiple
]