
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class AffectedFoundMessages(TLObject, family='TypeMessagesAffectedFoundMessages'):
    """
    Messages found and affected by changes
    """

    _id = 0XEF8D3E6C
    _group_id = 0XD9905748

    def __init__(
        self,
        pts: int,
        pts_count: int,
        offset: int,
        messages: List[int]
    ):

        """
        Messages found and affected by changes

        Args:
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            pts_count (int): [Number of events that were generated](https://core.telegram.org/api/updates)
            offset (int): If bigger than zero, the request must be repeated to remove more messages
            messages (List[int]): Affected message IDs
        """

        self.pts = pts
        self.pts_count = pts_count
        self.offset = offset
        self.messages = messages

    def to_bytes(self, boxed: bool=True):
        with Writer(b'l>\x8d\xef' if boxed else b'') as writer:
            writer.int(self.pts)
            writer.int(self.pts_count)
            writer.int(self.offset)
            writer.vector(
                self.messages,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        pts_ = reader.int()
        pts_count_ = reader.int()
        offset_ = reader.int()
        messages_ = reader.vector(
            reader.int
        )

        return cls(
            pts=pts_,
            pts_count=pts_count_,
            offset=offset_,
            messages=messages_
        )

TypeMessagesAffectedFoundMessages = AffectedFoundMessages