
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader
    from ..sticker_set_covered import TypeStickerSetCovered


class FeaturedStickersNotModified(TLObject, family='TypeMessagesFeaturedStickers'):
    """
    Featured stickers haven't changed
    """

    _id = 0XC6DC0C66
    _group_id = 0XF998299D

    def __init__(
        self,
        count: int
    ):

        """
        Featured stickers haven't changed

        Args:
            count (int): Total number of featured stickers
        """

        self.count = count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'f\x0c\xdc\xc6' if boxed else b'') as writer:
            writer.int(self.count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()

        return cls(
            count=count_
        )

class FeaturedStickers(TLObject, family='TypeMessagesFeaturedStickers'):
    """
    Featured stickersets
    """

    _id = 0XBE382906
    _group_id = 0XF998299D

    def __init__(
        self,
        hash: int,
        count: int,
        sets: List['TypeStickerSetCovered'],
        unread: List[int],
        premium: bool = False
    ):

        """
        Featured stickersets

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            count (int): Total number of featured stickers
            sets (List['TypeStickerSetCovered']): Featured stickersets
            unread (List[int]): IDs of new featured stickersets
            premium (bool, optional): Whether this is a premium stickerset
        """

        self.hash = hash
        self.count = count
        self.sets = sets
        self.unread = unread
        self.premium = premium

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x06)8\xbe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.premium, 0)
                writer.long(self.hash)
                writer.int(self.count)
                writer.vector(
                    self.sets,
                    lambda value: writer.object(
                        value,
                        group_id=0X16103538
                    )
                )
                writer.vector(
                    self.unread,
                    writer.long
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        hash_ = reader.long()
        count_ = reader.int()
        sets_ = reader.vector(
            lambda: reader.object(
                group_id=0X16103538
            )
        )

        unread_ = reader.vector(
            reader.long
        )

        return cls(
            hash=hash_,
            count=count_,
            sets=sets_,
            unread=unread_,
            premium=flags(0)
        )

TypeMessagesFeaturedStickers = Union[
    FeaturedStickersNotModified,
    FeaturedStickers
]