
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..bot_inline_result import TypeBotInlineResult
    from ....gadgets.byteutils import Reader
    from ..inline_query_peer_type import TypeInlineQueryPeerType


class PreparedInlineMessage(TLObject, family='TypeMessagesPreparedInlineMessage'):
    """
    Represents a [prepared inline message received via a bot's mini app, that can be sent to some chats](https://core.telegram.org/api/bots/inline#21-using-a-prepared-inline-message)
    """

    _id = 0XFF57708D
    _group_id = 0X688AED2B

    def __init__(
        self,
        query_id: int,
        result: 'TypeBotInlineResult',
        peer_types: List['TypeInlineQueryPeerType'],
        cache_time: int,
        users: List['TypeUser']
    ):

        """
        Represents a [prepared inline message received via a bot's mini app, that can be sent to some chats](https://core.telegram.org/api/bots/inline#21-using-a-prepared-inline-message)

        Args:
            query_id (int): The query_id to pass to [messages.sendInlineBotResult](https://core.telegram.org/method/messages.sendInlineBotResult)
            result ('TypeBotInlineResult'): The contents of the message, to be shown in a preview
            peer_types (List['TypeInlineQueryPeerType']): Types of chats where this message can be sent
            cache_time (int): Caching validity of the results
            users (List['TypeUser']): Users mentioned in the results
        """

        self.query_id = query_id
        self.result = result
        self.peer_types = peer_types
        self.cache_time = cache_time
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8dpW\xff' if boxed else b'') as writer:
            writer.long(self.query_id)
            writer.object(
                self.result,
                group_id=0X940CB1DA
            )
            writer.vector(
                self.peer_types,
                lambda value: writer.object(
                    value,
                    group_id=0X6AF2CA99
                )
            )
            writer.int(self.cache_time)
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        query_id_ = reader.long()
        result_ = reader.object(
            group_id=0X940CB1DA
        )

        peer_types_ = reader.vector(
            lambda: reader.object(
                group_id=0X6AF2CA99
            )
        )

        cache_time_ = reader.int()
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            query_id=query_id_,
            result=result_,
            peer_types=peer_types_,
            cache_time=cache_time_,
            users=users_
        )

TypeMessagesPreparedInlineMessage = PreparedInlineMessage