
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..document import TypeDocument
    from ..sticker_pack import TypeStickerPack
    from ....gadgets.byteutils import Reader


class RecentStickersNotModified(TLObject, family='TypeMessagesRecentStickers'):
    """
    No new recent sticker was found
    """

    _id = 0XB17F890
    _group_id = 0XE5E10C42


    def to_bytes(self, boxed: bool=True):
        return b'\x90\xf8\x17\x0b' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class RecentStickers(TLObject, family='TypeMessagesRecentStickers'):
    """
    Recently used stickers
    """

    _id = 0X88D37C56
    _group_id = 0XE5E10C42

    def __init__(
        self,
        hash: int,
        packs: List['TypeStickerPack'],
        stickers: List['TypeDocument'],
        dates: List[int]
    ):

        """
        Recently used stickers

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            packs (List['TypeStickerPack']): Emojis associated to stickers
            stickers (List['TypeDocument']): Recent stickers
            dates (List[int]): When was each sticker last used
        """

        self.hash = hash
        self.packs = packs
        self.stickers = stickers
        self.dates = dates

    def to_bytes(self, boxed: bool=True):
        with Writer(b'V|\xd3\x88' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.packs,
                lambda value: writer.object(
                    value,
                    group_id=0X6962BC17
                )
            )
            writer.vector(
                self.stickers,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )
            writer.vector(
                self.dates,
                writer.int
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        packs_ = reader.vector(
            lambda: reader.object(
                group_id=0X6962BC17
            )
        )

        stickers_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        dates_ = reader.vector(
            reader.int
        )

        return cls(
            hash=hash_,
            packs=packs_,
            stickers=stickers_,
            dates=dates_
        )

TypeMessagesRecentStickers = Union[
    RecentStickersNotModified,
    RecentStickers
]