
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..document import TypeDocument
    from ....gadgets.byteutils import Reader


class SavedGifsNotModified(TLObject, family='TypeMessagesSavedGifs'):
    """
    No new saved gifs were found
    """

    _id = 0XE8025CA2
    _group_id = 0XC927198E


    def to_bytes(self, boxed: bool=True):
        return b'\xa2\\\x02\xe8' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SavedGifs(TLObject, family='TypeMessagesSavedGifs'):
    """
    Saved gifs
    """

    _id = 0X84A02A0D
    _group_id = 0XC927198E

    def __init__(
        self,
        hash: int,
        gifs: List['TypeDocument']
    ):

        """
        Saved gifs

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            gifs (List['TypeDocument']): List of saved gifs
        """

        self.hash = hash
        self.gifs = gifs

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\r*\xa0\x84' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.vector(
                self.gifs,
                lambda value: writer.object(
                    value,
                    group_id=0X6547BD50
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        gifs_ = reader.vector(
            lambda: reader.object(
                group_id=0X6547BD50
            )
        )

        return cls(
            hash=hash_,
            gifs=gifs_
        )

TypeMessagesSavedGifs = Union[
    SavedGifsNotModified,
    SavedGifs
]