
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..web_page import TypeWebPage
    from ....gadgets.byteutils import Reader


class WebPage(TLObject, family='TypeMessagesWebPage'):
    """
    Represents an Instant View webpage.
    """

    _id = 0XFD5E12BD
    _group_id = 0X4F030505

    def __init__(
        self,
        webpage: 'TypeWebPage',
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Represents an Instant View webpage.

        Args:
            webpage ('TypeWebPage'): The instant view webpage.
            chats (List['TypeChat']): Chats mentioned in the webpage.
            users (List['TypeUser']): Users mentioned in the webpage.
        """

        self.webpage = webpage
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbd\x12^\xfd' if boxed else b'') as writer:
            writer.object(
                self.webpage,
                group_id=0X9D177ED
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        webpage_ = reader.object(
            group_id=0X9D177ED
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            webpage=webpage_,
            chats=chats_,
            users=users_
        )

TypeMessagesWebPage = WebPage