
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .chat import TypeChat
    from .rich_text import TypeRichText
    from .geo_point import TypeGeoPoint
    from .page_caption import TypePageCaption
    from .page_list_item import TypePageListItem
    from .page_table_row import TypePageTableRow
    from ...gadgets.byteutils import Reader
    from .page_related_article import TypePageRelatedArticle
    from .page_list_ordered_item import TypePageListOrderedItem


class PageBlockUnsupported(TLObject, family='TypePageBlock'):
    """
    Unsupported IV element
    """

    _id = 0X13567E8A
    _group_id = 0X4A8B7F2D


    def to_bytes(self, boxed: bool=True):
        return b'\x8a~V\x13' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PageBlockTitle(TLObject, family='TypePageBlock'):
    """
    Title
    """

    _id = 0X70ABC3FD
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Title

        Args:
            text ('TypeRichText'): Title
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfd\xc3\xabp' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockSubtitle(TLObject, family='TypePageBlock'):
    """
    Subtitle
    """

    _id = 0X8FFA9A1F
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Subtitle

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1f\x9a\xfa\x8f' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockAuthorDate(TLObject, family='TypePageBlock'):
    """
    Author and date of creation of article
    """

    _id = 0XBAAFE5E0
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        author: 'TypeRichText',
        published_date: int
    ):

        """
        Author and date of creation of article

        Args:
            author ('TypeRichText'): Author name
            published_date (int): Date of publication
        """

        self.author = author
        self.published_date = published_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe0\xe5\xaf\xba' if boxed else b'') as writer:
            writer.object(
                self.author,
                group_id=0XB588E109
            )
            writer.int(self.published_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        author_ = reader.object(
            group_id=0XB588E109
        )

        published_date_ = reader.int()

        return cls(
            author=author_,
            published_date=published_date_
        )

class PageBlockHeader(TLObject, family='TypePageBlock'):
    """
    Page header
    """

    _id = 0XBFD064EC
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Page header

        Args:
            text ('TypeRichText'): Contents
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xecd\xd0\xbf' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockSubheader(TLObject, family='TypePageBlock'):
    """
    Subheader
    """

    _id = 0XF12BB6E1
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Subheader

        Args:
            text ('TypeRichText'): Subheader
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\xb6+\xf1' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockParagraph(TLObject, family='TypePageBlock'):
    """
    A paragraph
    """

    _id = 0X467A0766
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        A paragraph

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'f\x07zF' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockPreformatted(TLObject, family='TypePageBlock'):
    """
    Preformatted ( <pre> text)
    """

    _id = 0XC070D93E
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText',
        language: str
    ):

        """
        Preformatted ( <pre> text)

        Args:
            text ('TypeRichText'): Text
            language (str): Programming language of preformatted text
        """

        self.text = text
        self.language = language

    def to_bytes(self, boxed: bool=True):
        with Writer(b'>\xd9p\xc0' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.string(self.language)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        language_ = reader.string()

        return cls(
            text=text_,
            language=language_
        )

class PageBlockFooter(TLObject, family='TypePageBlock'):
    """
    Page footer
    """

    _id = 0X48870999
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Page footer

        Args:
            text ('TypeRichText'): Contents
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99\t\x87H' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockDivider(TLObject, family='TypePageBlock'):
    """
    An empty block separating a page
    """

    _id = 0XDB20B188
    _group_id = 0X4A8B7F2D


    def to_bytes(self, boxed: bool=True):
        return b'\x88\xb1 \xdb' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PageBlockAnchor(TLObject, family='TypePageBlock'):
    """
    Link to section within the page itself (like <a href="#target">anchor</a>)
    """

    _id = 0XCE0D37B0
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        name: str
    ):

        """
        Link to section within the page itself (like <a href="#target">anchor</a>)

        Args:
            name (str): Name of target section
        """

        self.name = name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb07\r\xce' if boxed else b'') as writer:
            writer.string(self.name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        name_ = reader.string()

        return cls(
            name=name_
        )

class PageBlockList(TLObject, family='TypePageBlock'):
    """
    Unordered list of IV blocks
    """

    _id = 0XE4E88011
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        items: List['TypePageListItem']
    ):

        """
        Unordered list of IV blocks

        Args:
            items (List['TypePageListItem']): List of blocks in an IV page
        """

        self.items = items

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x11\x80\xe8\xe4' if boxed else b'') as writer:
            writer.vector(
                self.items,
                lambda value: writer.object(
                    value,
                    group_id=0X8E35A2A3
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        items_ = reader.vector(
            lambda: reader.object(
                group_id=0X8E35A2A3
            )
        )

        return cls(
            items=items_
        )

class PageBlockBlockquote(TLObject, family='TypePageBlock'):
    """
    Quote (equivalent to the HTML <blockquote>)
    """

    _id = 0X263D7C26
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText',
        caption: 'TypeRichText'
    ):

        """
        Quote (equivalent to the HTML <blockquote>)

        Args:
            text ('TypeRichText'): Quote contents
            caption ('TypeRichText'): Caption
        """

        self.text = text
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'&|=&' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.object(
                self.caption,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        caption_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_,
            caption=caption_
        )

class PageBlockPullquote(TLObject, family='TypePageBlock'):
    """
    Pullquote
    """

    _id = 0X4F4456D3
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText',
        caption: 'TypeRichText'
    ):

        """
        Pullquote

        Args:
            text ('TypeRichText'): Text
            caption ('TypeRichText'): Caption
        """

        self.text = text
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd3VDO' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.object(
                self.caption,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        caption_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_,
            caption=caption_
        )

class PageBlockPhoto(TLObject, family='TypePageBlock'):
    """
    A photo
    """

    _id = 0X1759C560
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        photo_id: int,
        caption: 'TypePageCaption',
        url: Optional[str] = None,
        webpage_id: Optional[int] = None
    ):

        """
        A photo

        Args:
            photo_id (int): Photo ID
            caption ('TypePageCaption'): Caption
            url (Optional[str], optional): HTTP URL of page the photo leads to when clicked
            webpage_id (Optional[int], optional): ID of preview of the page the photo leads to when clicked
        """

        self.photo_id = photo_id
        self.caption = caption
        self.url = url
        self.webpage_id = webpage_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'`\xc5Y\x17' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.photo_id)
                writer.object(
                    self.caption,
                    group_id=0XDF35F670
                )

                if flags(self.url, 0):
                    writer.string(self.url)

                if flags(self.webpage_id, 0):
                    writer.long(self.webpage_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        photo_id_ = reader.long()
        caption_ = reader.object(
            group_id=0XDF35F670
        )

        url_ = (
            reader.string()
            if flags(0) else None
        )

        webpage_id_ = (
            reader.long()
            if flags(0) else None
        )

        return cls(
            photo_id=photo_id_,
            caption=caption_,
            url=url_,
            webpage_id=webpage_id_
        )

class PageBlockVideo(TLObject, family='TypePageBlock'):
    """
    Video
    """

    _id = 0X7C8FE7B6
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        video_id: int,
        caption: 'TypePageCaption',
        autoplay: bool = False,
        loop: bool = False
    ):

        """
        Video

        Args:
            video_id (int): Video ID
            caption ('TypePageCaption'): Caption
            autoplay (bool, optional): Whether the video is set to autoplay
            loop (bool, optional): Whether the video is set to loop
        """

        self.video_id = video_id
        self.caption = caption
        self.autoplay = autoplay
        self.loop = loop

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb6\xe7\x8f|' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.autoplay, 0)
                flags(self.loop, 1)
                writer.long(self.video_id)
                writer.object(
                    self.caption,
                    group_id=0XDF35F670
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        video_id_ = reader.long()
        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            video_id=video_id_,
            caption=caption_,
            autoplay=flags(0),
            loop=flags(1)
        )

class PageBlockCover(TLObject, family='TypePageBlock'):
    """
    A page cover
    """

    _id = 0X39F23300
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        cover: 'TypePageBlock'
    ):

        """
        A page cover

        Args:
            cover ('TypePageBlock'): Cover
        """

        self.cover = cover

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x003\xf29' if boxed else b'') as writer:
            writer.object(
                self.cover,
                group_id=0X4A8B7F2D
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        cover_ = reader.object(
            group_id=0X4A8B7F2D
        )

        return cls(
            cover=cover_
        )

class PageBlockEmbed(TLObject, family='TypePageBlock'):
    """
    An embedded webpage
    """

    _id = 0XA8718DC5
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        caption: 'TypePageCaption',
        full_width: bool = False,
        allow_scrolling: bool = False,
        url: Optional[str] = None,
        html: Optional[str] = None,
        poster_photo_id: Optional[int] = None,
        w: Optional[int] = None,
        h: Optional[int] = None
    ):

        """
        An embedded webpage

        Args:
            caption ('TypePageCaption'): Caption
            full_width (bool, optional): Whether the block should be full width
            allow_scrolling (bool, optional): Whether scrolling should be allowed
            url (Optional[str], optional): Web page URL, if available
            html (Optional[str], optional): HTML-markup of the embedded page
            poster_photo_id (Optional[int], optional): Poster photo, if available
            w (Optional[int], optional): Block width, if known
            h (Optional[int], optional): Block height, if known
        """

        self.caption = caption
        self.full_width = full_width
        self.allow_scrolling = allow_scrolling
        self.url = url
        self.html = html
        self.poster_photo_id = poster_photo_id
        self.w = w
        self.h = h

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc5\x8dq\xa8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.full_width, 0)
                flags(self.allow_scrolling, 3)

                if flags(self.url, 1):
                    writer.string(self.url)

                if flags(self.html, 2):
                    writer.string(self.html)

                if flags(self.poster_photo_id, 4):
                    writer.long(self.poster_photo_id)

                if flags(self.w, 5):
                    writer.int(self.w)

                if flags(self.h, 5):
                    writer.int(self.h)
                writer.object(
                    self.caption,
                    group_id=0XDF35F670
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = (
            reader.string()
            if flags(1) else None
        )

        html_ = (
            reader.string()
            if flags(2) else None
        )

        poster_photo_id_ = (
            reader.long()
            if flags(4) else None
        )

        w_ = (
            reader.int()
            if flags(5) else None
        )

        h_ = (
            reader.int()
            if flags(5) else None
        )

        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            caption=caption_,
            full_width=flags(0),
            allow_scrolling=flags(3),
            url=url_,
            html=html_,
            poster_photo_id=poster_photo_id_,
            w=w_,
            h=h_
        )

class PageBlockEmbedPost(TLObject, family='TypePageBlock'):
    """
    An embedded post
    """

    _id = 0XF259A80B
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        url: str,
        webpage_id: int,
        author_photo_id: int,
        author: str,
        date: int,
        blocks: List['TypePageBlock'],
        caption: 'TypePageCaption'
    ):

        """
        An embedded post

        Args:
            url (str): Web page URL
            webpage_id (int): ID of generated webpage preview
            author_photo_id (int): ID of the author's photo
            author (str): Author name
            date (int): Creation date
            blocks (List['TypePageBlock']): Post contents
            caption ('TypePageCaption'): Caption
        """

        self.url = url
        self.webpage_id = webpage_id
        self.author_photo_id = author_photo_id
        self.author = author
        self.date = date
        self.blocks = blocks
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0b\xa8Y\xf2' if boxed else b'') as writer:
            writer.string(self.url)
            writer.long(self.webpage_id)
            writer.long(self.author_photo_id)
            writer.string(self.author)
            writer.int(self.date)
            writer.vector(
                self.blocks,
                lambda value: writer.object(
                    value,
                    group_id=0X4A8B7F2D
                )
            )
            writer.object(
                self.caption,
                group_id=0XDF35F670
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        webpage_id_ = reader.long()
        author_photo_id_ = reader.long()
        author_ = reader.string()
        date_ = reader.int()
        blocks_ = reader.vector(
            lambda: reader.object(
                group_id=0X4A8B7F2D
            )
        )

        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            url=url_,
            webpage_id=webpage_id_,
            author_photo_id=author_photo_id_,
            author=author_,
            date=date_,
            blocks=blocks_,
            caption=caption_
        )

class PageBlockCollage(TLObject, family='TypePageBlock'):
    """
    Collage of media
    """

    _id = 0X65A0FA4D
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        items: List['TypePageBlock'],
        caption: 'TypePageCaption'
    ):

        """
        Collage of media

        Args:
            items (List['TypePageBlock']): Media elements
            caption ('TypePageCaption'): Caption
        """

        self.items = items
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'M\xfa\xa0e' if boxed else b'') as writer:
            writer.vector(
                self.items,
                lambda value: writer.object(
                    value,
                    group_id=0X4A8B7F2D
                )
            )
            writer.object(
                self.caption,
                group_id=0XDF35F670
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        items_ = reader.vector(
            lambda: reader.object(
                group_id=0X4A8B7F2D
            )
        )

        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            items=items_,
            caption=caption_
        )

class PageBlockSlideshow(TLObject, family='TypePageBlock'):
    """
    Slideshow
    """

    _id = 0X31F9590
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        items: List['TypePageBlock'],
        caption: 'TypePageCaption'
    ):

        """
        Slideshow

        Args:
            items (List['TypePageBlock']): Slideshow items
            caption ('TypePageCaption'): Caption
        """

        self.items = items
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x90\x95\x1f\x03' if boxed else b'') as writer:
            writer.vector(
                self.items,
                lambda value: writer.object(
                    value,
                    group_id=0X4A8B7F2D
                )
            )
            writer.object(
                self.caption,
                group_id=0XDF35F670
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        items_ = reader.vector(
            lambda: reader.object(
                group_id=0X4A8B7F2D
            )
        )

        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            items=items_,
            caption=caption_
        )

class PageBlockChannel(TLObject, family='TypePageBlock'):
    """
    Reference to a telegram channel
    """

    _id = 0XEF1751B5
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        channel: 'TypeChat'
    ):

        """
        Reference to a telegram channel

        Args:
            channel ('TypeChat'): The channel/supergroup/chat
        """

        self.channel = channel

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5Q\x17\xef' if boxed else b'') as writer:
            writer.object(
                self.channel,
                group_id=0X73A5C0D9
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_ = reader.object(
            group_id=0X73A5C0D9
        )

        return cls(
            channel=channel_
        )

class PageBlockAudio(TLObject, family='TypePageBlock'):
    """
    Audio
    """

    _id = 0X804361EA
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        audio_id: int,
        caption: 'TypePageCaption'
    ):

        """
        Audio

        Args:
            audio_id (int): Audio ID (to be fetched from the container [page](https://core.telegram.org/constructor/page) constructor
            caption ('TypePageCaption'): Audio caption
        """

        self.audio_id = audio_id
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeaaC\x80' if boxed else b'') as writer:
            writer.long(self.audio_id)
            writer.object(
                self.caption,
                group_id=0XDF35F670
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        audio_id_ = reader.long()
        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            audio_id=audio_id_,
            caption=caption_
        )

class PageBlockKicker(TLObject, family='TypePageBlock'):
    """
    Kicker
    """

    _id = 0X1E148390
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Kicker

        Args:
            text ('TypeRichText'): Contents
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x90\x83\x14\x1e' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class PageBlockTable(TLObject, family='TypePageBlock'):
    """
    Table
    """

    _id = 0XBF4DEA82
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        title: 'TypeRichText',
        rows: List['TypePageTableRow'],
        bordered: bool = False,
        striped: bool = False
    ):

        """
        Table

        Args:
            title ('TypeRichText'): Title
            rows (List['TypePageTableRow']): Table rows
            bordered (bool, optional): Does the table have a visible border?
            striped (bool, optional): Is the table striped?
        """

        self.title = title
        self.rows = rows
        self.bordered = bordered
        self.striped = striped

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x82\xeaM\xbf' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.bordered, 0)
                flags(self.striped, 1)
                writer.object(
                    self.title,
                    group_id=0XB588E109
                )
                writer.vector(
                    self.rows,
                    lambda value: writer.object(
                        value,
                        group_id=0X5B37F003
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.object(
            group_id=0XB588E109
        )

        rows_ = reader.vector(
            lambda: reader.object(
                group_id=0X5B37F003
            )
        )

        return cls(
            title=title_,
            rows=rows_,
            bordered=flags(0),
            striped=flags(1)
        )

class PageBlockOrderedList(TLObject, family='TypePageBlock'):
    """
    Ordered list of IV blocks
    """

    _id = 0X9A8AE1E1
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        items: List['TypePageListOrderedItem']
    ):

        """
        Ordered list of IV blocks

        Args:
            items (List['TypePageListOrderedItem']): List items
        """

        self.items = items

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\xe1\x8a\x9a' if boxed else b'') as writer:
            writer.vector(
                self.items,
                lambda value: writer.object(
                    value,
                    group_id=0X2B983E3E
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        items_ = reader.vector(
            lambda: reader.object(
                group_id=0X2B983E3E
            )
        )

        return cls(
            items=items_
        )

class PageBlockDetails(TLObject, family='TypePageBlock'):
    """
    A collapsible details block
    """

    _id = 0X76768BED
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        blocks: List['TypePageBlock'],
        title: 'TypeRichText',
        open: bool = False
    ):

        """
        A collapsible details block

        Args:
            blocks (List['TypePageBlock']): Block contents
            title ('TypeRichText'): Always visible heading for the block
            open (bool, optional): Whether the block is open by default
        """

        self.blocks = blocks
        self.title = title
        self.open = open

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xed\x8bvv' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.open, 0)
                writer.vector(
                    self.blocks,
                    lambda value: writer.object(
                        value,
                        group_id=0X4A8B7F2D
                    )
                )
                writer.object(
                    self.title,
                    group_id=0XB588E109
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        blocks_ = reader.vector(
            lambda: reader.object(
                group_id=0X4A8B7F2D
            )
        )

        title_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            blocks=blocks_,
            title=title_,
            open=flags(0)
        )

class PageBlockRelatedArticles(TLObject, family='TypePageBlock'):
    """
    Related articles
    """

    _id = 0X16115A96
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        title: 'TypeRichText',
        articles: List['TypePageRelatedArticle']
    ):

        """
        Related articles

        Args:
            title ('TypeRichText'): Title
            articles (List['TypePageRelatedArticle']): Related articles
        """

        self.title = title
        self.articles = articles

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x96Z\x11\x16' if boxed else b'') as writer:
            writer.object(
                self.title,
                group_id=0XB588E109
            )
            writer.vector(
                self.articles,
                lambda value: writer.object(
                    value,
                    group_id=0XCEDB609A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.object(
            group_id=0XB588E109
        )

        articles_ = reader.vector(
            lambda: reader.object(
                group_id=0XCEDB609A
            )
        )

        return cls(
            title=title_,
            articles=articles_
        )

class PageBlockMap(TLObject, family='TypePageBlock'):
    """
    A map
    """

    _id = 0XA44F3EF6
    _group_id = 0X4A8B7F2D

    def __init__(
        self,
        geo: 'TypeGeoPoint',
        zoom: int,
        w: int,
        h: int,
        caption: 'TypePageCaption'
    ):

        """
        A map

        Args:
            geo ('TypeGeoPoint'): Location of the map center
            zoom (int): Map zoom level; 13-20
            w (int): Map width in pixels before applying scale; 16-102
            h (int): Map height in pixels before applying scale; 16-1024
            caption ('TypePageCaption'): Caption
        """

        self.geo = geo
        self.zoom = zoom
        self.w = w
        self.h = h
        self.caption = caption

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf6>O\xa4' if boxed else b'') as writer:
            writer.object(
                self.geo,
                group_id=0X9248B41D
            )
            writer.int(self.zoom)
            writer.int(self.w)
            writer.int(self.h)
            writer.object(
                self.caption,
                group_id=0XDF35F670
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        geo_ = reader.object(
            group_id=0X9248B41D
        )

        zoom_ = reader.int()
        w_ = reader.int()
        h_ = reader.int()
        caption_ = reader.object(
            group_id=0XDF35F670
        )

        return cls(
            geo=geo_,
            zoom=zoom_,
            w=w_,
            h=h_,
            caption=caption_
        )

TypePageBlock = Union[
    PageBlockUnsupported,
    PageBlockTitle,
    PageBlockSubtitle,
    PageBlockAuthorDate,
    PageBlockHeader,
    PageBlockSubheader,
    PageBlockParagraph,
    PageBlockPreformatted,
    PageBlockFooter,
    PageBlockDivider,
    PageBlockAnchor,
    PageBlockList,
    PageBlockBlockquote,
    PageBlockPullquote,
    PageBlockPhoto,
    PageBlockVideo,
    PageBlockCover,
    PageBlockEmbed,
    PageBlockEmbedPost,
    PageBlockCollage,
    PageBlockSlideshow,
    PageBlockChannel,
    PageBlockAudio,
    PageBlockKicker,
    PageBlockTable,
    PageBlockOrderedList,
    PageBlockDetails,
    PageBlockRelatedArticles,
    PageBlockMap
]