
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..bank_card_open_url import TypeBankCardOpenUrl
    from ....gadgets.byteutils import Reader


class BankCardData(TLObject, family='TypePaymentsBankCardData'):
    """
    Credit card info, provided by the card's bank(s)
    """

    _id = 0X3E24E573
    _group_id = 0XFA178021

    def __init__(
        self,
        title: str,
        open_urls: List['TypeBankCardOpenUrl']
    ):

        """
        Credit card info, provided by the card's bank(s)

        Args:
            title (str): Credit card title
            open_urls (List['TypeBankCardOpenUrl']): Info URL(s) provided by the card's bank(s)
        """

        self.title = title
        self.open_urls = open_urls

    def to_bytes(self, boxed: bool=True):
        with Writer(b's\xe5$>' if boxed else b'') as writer:
            writer.string(self.title)
            writer.vector(
                self.open_urls,
                lambda value: writer.object(
                    value,
                    group_id=0X5EDC4401
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        open_urls_ = reader.vector(
            lambda: reader.object(
                group_id=0X5EDC4401
            )
        )

        return cls(
            title=title_,
            open_urls=open_urls_
        )

TypePaymentsBankCardData = BankCardData