
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader
    from ..payment_requested_info import TypePaymentRequestedInfo


class SavedInfo(TLObject, family='TypePaymentsSavedInfo'):
    """
    Saved server-side order information
    """

    _id = 0XFB8FE43C
    _group_id = 0X11260D69

    def __init__(
        self,
        has_saved_credentials: bool = False,
        saved_info: Optional['TypePaymentRequestedInfo'] = None
    ):

        """
        Saved server-side order information

        Args:
            has_saved_credentials (bool, optional): Whether the user has some saved payment credentials
            saved_info (Optional['TypePaymentRequestedInfo'], optional): Saved server-side order information
        """

        self.has_saved_credentials = has_saved_credentials
        self.saved_info = saved_info

    def to_bytes(self, boxed: bool=True):
        with Writer(b'<\xe4\x8f\xfb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_saved_credentials, 1)

                if flags(self.saved_info, 0):
                    writer.object(
                        self.saved_info,
                        group_id=0X89AE5563
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        saved_info_ = (
            reader.object(
                group_id=0X89AE5563
            )
            if flags(0) else None
        )

        return cls(
            has_saved_credentials=flags(1),
            saved_info=saved_info_
        )

TypePaymentsSavedInfo = SavedInfo