
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..stars_amount import TypeStarsAmount
    from ..stars_transaction import TypeStarsTransaction
    from ..stars_subscription import TypeStarsSubscription
    from ....gadgets.byteutils import Reader


class StarsStatus(TLObject, family='TypePaymentsStarsStatus'):
    """
    Info about the current [Telegram Star subscriptions, balance and transaction history](https://core.telegram.org/api/stars#balance-and-transaction-history).
    """

    _id = 0X6C9CE8ED
    _group_id = 0XC88B272F

    def __init__(
        self,
        balance: 'TypeStarsAmount',
        chats: List['TypeChat'],
        users: List['TypeUser'],
        subscriptions: Optional[List['TypeStarsSubscription']] = None,
        subscriptions_next_offset: Optional[str] = None,
        subscriptions_missing_balance: Optional[int] = None,
        history: Optional[List['TypeStarsTransaction']] = None,
        next_offset: Optional[str] = None
    ):

        """
        Info about the current [Telegram Star subscriptions, balance and transaction history](https://core.telegram.org/api/stars#balance-and-transaction-history).

        Args:
            balance ('TypeStarsAmount'): Current Telegram Star balance.
            chats (List['TypeChat']): Chats mentioned in history.
            users (List['TypeUser']): Users mentioned in history.
            subscriptions (Optional[List['TypeStarsSubscription']], optional): Info about current Telegram Star subscriptions, only returned when invoking [payments.getStarsTransactions](https://core.telegram.org/method/payments.getStarsTransactions) and [payments.getStarsSubscriptions](https://core.telegram.org/method/payments.getStarsSubscriptions).
            subscriptions_next_offset (Optional[str], optional): Offset for pagination of subscriptions: only usable and returned when invoking [payments.getStarsSubscriptions](https://core.telegram.org/method/payments.getStarsSubscriptions).
            subscriptions_missing_balance (Optional[int], optional): The number of Telegram Stars the user should buy to be able to extend expired subscriptions soon (i.e. the current balance is not enough to extend all expired subscriptions).
            history (Optional[List['TypeStarsTransaction']], optional): List of Telegram Star transactions (partial if next_offset is set).
            next_offset (Optional[str], optional): Offset to use to fetch more transactions from the transaction history using [payments.getStarsTransactions](https://core.telegram.org/method/payments.getStarsTransactions).
        """

        self.balance = balance
        self.chats = chats
        self.users = users
        self.subscriptions = subscriptions
        self.subscriptions_next_offset = subscriptions_next_offset
        self.subscriptions_missing_balance = subscriptions_missing_balance
        self.history = history
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xed\xe8\x9cl' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.balance,
                    group_id=0XC3D62A83
                )

                if flags(self.subscriptions, 1):
                    writer.vector(
                        self.subscriptions,
                        lambda value: writer.object(
                            value,
                            group_id=0X857BF81E
                        )
                    )

                if flags(self.subscriptions_next_offset, 2):
                    writer.string(self.subscriptions_next_offset)

                if flags(self.subscriptions_missing_balance, 4):
                    writer.long(self.subscriptions_missing_balance)

                if flags(self.history, 3):
                    writer.vector(
                        self.history,
                        lambda value: writer.object(
                            value,
                            group_id=0X169B64E1
                        )
                    )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        balance_ = reader.object(
            group_id=0XC3D62A83
        )

        subscriptions_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X857BF81E
                )
            )
            if flags(1) else None
        )

        subscriptions_next_offset_ = (
            reader.string()
            if flags(2) else None
        )

        subscriptions_missing_balance_ = (
            reader.long()
            if flags(4) else None
        )

        history_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X169B64E1
                )
            )
            if flags(3) else None
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            balance=balance_,
            chats=chats_,
            users=users_,
            subscriptions=subscriptions_,
            subscriptions_next_offset=subscriptions_next_offset_,
            subscriptions_missing_balance=subscriptions_missing_balance_,
            history=history_,
            next_offset=next_offset_
        )

TypePaymentsStarsStatus = StarsStatus