
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class PeerBlocked(TLObject, family='TypePeerBlocked'):
    """
    Information about a blocked peer
    """

    _id = 0XE8FD8014
    _group_id = 0XA27FE45B

    def __init__(
        self,
        peer_id: 'TypePeer',
        date: int
    ):

        """
        Information about a blocked peer

        Args:
            peer_id ('TypePeer'): Peer ID
            date (int): When was the peer blocked
        """

        self.peer_id = peer_id
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x14\x80\xfd\xe8' if boxed else b'') as writer:
            writer.object(
                self.peer_id,
                group_id=0XB4DECBCA
            )
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        date_ = reader.int()

        return cls(
            peer_id=peer_id_,
            date=date_
        )

TypePeerBlocked = PeerBlocked