
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .data_json import TypeDataJSON
    from .phone_connection import TypePhoneConnection
    from ...gadgets.byteutils import Reader
    from .phone_call_protocol import TypePhoneCallProtocol
    from .phone_call_discard_reason import TypePhoneCallDiscardReason


class PhoneCallEmpty(TLObject, family='TypePhoneCall'):
    """
    Empty constructor
    """

    _id = 0X5366C915
    _group_id = 0X943E32B8

    def __init__(
        self,
        id: int
    ):

        """
        Empty constructor

        Args:
            id (int): Call ID
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x15\xc9fS' if boxed else b'') as writer:
            writer.long(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()

        return cls(
            id=id_
        )

class PhoneCallWaiting(TLObject, family='TypePhoneCall'):
    """
    Incoming phone call
    """

    _id = 0XC5226F17
    _group_id = 0X943E32B8

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int,
        protocol: 'TypePhoneCallProtocol',
        video: bool = False,
        receive_date: Optional[int] = None
    ):

        """
        Incoming phone call

        Args:
            id (int): Call ID
            access_hash (int): Access hash
            date (int): Date
            admin_id (int): Admin ID
            participant_id (int): Participant ID
            protocol ('TypePhoneCallProtocol'): Phone call protocol info
            video (bool, optional): Is this a video call
            receive_date (Optional[int], optional): When was the phone call received
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.protocol = protocol
        self.video = video
        self.receive_date = receive_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x17o"\xc5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.video, 6)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.int(self.date)
                writer.long(self.admin_id)
                writer.long(self.participant_id)
                writer.object(
                    self.protocol,
                    group_id=0X11AF407E
                )

                if flags(self.receive_date, 0):
                    writer.int(self.receive_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()
        protocol_ = reader.object(
            group_id=0X11AF407E
        )

        receive_date_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_,
            protocol=protocol_,
            video=flags(6),
            receive_date=receive_date_
        )

class PhoneCallRequested(TLObject, family='TypePhoneCall'):
    """
    Requested phone call
    """

    _id = 0X14B0ED0C
    _group_id = 0X943E32B8

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int,
        g_a_hash: bytes,
        protocol: 'TypePhoneCallProtocol',
        video: bool = False
    ):

        """
        Requested phone call

        Args:
            id (int): Phone call ID
            access_hash (int): Access hash
            date (int): When was the phone call created
            admin_id (int): ID of the creator of the phone call
            participant_id (int): ID of the other participant of the phone call
            g_a_hash (bytes): [Parameter for key exchange](https://core.telegram.org/api/end-to-end/voice-calls)
            protocol ('TypePhoneCallProtocol'): Call protocol info to be passed to libtgvoip
            video (bool, optional): Whether this is a video call
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_hash = g_a_hash
        self.protocol = protocol
        self.video = video

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0c\xed\xb0\x14' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.video, 6)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.int(self.date)
                writer.long(self.admin_id)
                writer.long(self.participant_id)
                writer.bytes(self.g_a_hash)
                writer.object(
                    self.protocol,
                    group_id=0X11AF407E
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()
        g_a_hash_ = reader.bytes()
        protocol_ = reader.object(
            group_id=0X11AF407E
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_,
            g_a_hash=g_a_hash_,
            protocol=protocol_,
            video=flags(6)
        )

class PhoneCallAccepted(TLObject, family='TypePhoneCall'):
    """
    An accepted phone call
    """

    _id = 0X3660C311
    _group_id = 0X943E32B8

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int,
        g_b: bytes,
        protocol: 'TypePhoneCallProtocol',
        video: bool = False
    ):

        """
        An accepted phone call

        Args:
            id (int): ID of accepted phone call
            access_hash (int): Access hash of phone call
            date (int): When was the call accepted
            admin_id (int): ID of the call creator
            participant_id (int): ID of the other user in the call
            g_b (bytes): B parameter for [secure E2E phone call key exchange](https://core.telegram.org/api/end-to-end/voice-calls)
            protocol ('TypePhoneCallProtocol'): Protocol to use for phone call
            video (bool, optional): Whether this is a video call
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_b = g_b
        self.protocol = protocol
        self.video = video

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x11\xc3`6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.video, 6)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.int(self.date)
                writer.long(self.admin_id)
                writer.long(self.participant_id)
                writer.bytes(self.g_b)
                writer.object(
                    self.protocol,
                    group_id=0X11AF407E
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()
        g_b_ = reader.bytes()
        protocol_ = reader.object(
            group_id=0X11AF407E
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_,
            g_b=g_b_,
            protocol=protocol_,
            video=flags(6)
        )

class PhoneCall(TLObject, family='TypePhoneCall'):
    """
    Phone call
    """

    _id = 0X30535AF5
    _group_id = 0X943E32B8

    def __init__(
        self,
        id: int,
        access_hash: int,
        date: int,
        admin_id: int,
        participant_id: int,
        g_a_or_b: bytes,
        key_fingerprint: int,
        protocol: 'TypePhoneCallProtocol',
        connections: List['TypePhoneConnection'],
        start_date: int,
        p2p_allowed: bool = False,
        video: bool = False,
        conference_supported: bool = False,
        custom_parameters: Optional['TypeDataJSON'] = None
    ):

        """
        Phone call

        Args:
            id (int): Call ID
            access_hash (int): Access hash
            date (int): Date of creation of the call
            admin_id (int): User ID of the creator of the call
            participant_id (int): User ID of the other participant in the call
            g_a_or_b (bytes): [Parameter for key exchange](https://core.telegram.org/api/end-to-end/voice-calls)
            key_fingerprint (int): [Key fingerprint](https://core.telegram.org/api/end-to-end/voice-calls)
            protocol ('TypePhoneCallProtocol'): Call protocol info to be passed to libtgvoip
            connections (List['TypePhoneConnection']): List of endpoints the user can connect to exchange call data
            start_date (int): When was the call actually started
            p2p_allowed (bool, optional): Whether P2P connection to the other peer is allowed
            video (bool, optional): Whether this is a video call
            conference_supported (bool, optional): ...
            custom_parameters (Optional['TypeDataJSON'], optional): Custom JSON-encoded call parameters to be passed to tgcalls.
        """

        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_or_b = g_a_or_b
        self.key_fingerprint = key_fingerprint
        self.protocol = protocol
        self.connections = connections
        self.start_date = start_date
        self.p2p_allowed = p2p_allowed
        self.video = video
        self.conference_supported = conference_supported
        self.custom_parameters = custom_parameters

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf5ZS0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.p2p_allowed, 5)
                flags(self.video, 6)
                flags(self.conference_supported, 8)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.int(self.date)
                writer.long(self.admin_id)
                writer.long(self.participant_id)
                writer.bytes(self.g_a_or_b)
                writer.long(self.key_fingerprint)
                writer.object(
                    self.protocol,
                    group_id=0X11AF407E
                )
                writer.vector(
                    self.connections,
                    lambda value: writer.object(
                        value,
                        group_id=0X6B3E602
                    )
                )
                writer.int(self.start_date)

                if flags(self.custom_parameters, 7):
                    writer.object(
                        self.custom_parameters,
                        group_id=0XE95B0798
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        date_ = reader.int()
        admin_id_ = reader.long()
        participant_id_ = reader.long()
        g_a_or_b_ = reader.bytes()
        key_fingerprint_ = reader.long()
        protocol_ = reader.object(
            group_id=0X11AF407E
        )

        connections_ = reader.vector(
            lambda: reader.object(
                group_id=0X6B3E602
            )
        )

        start_date_ = reader.int()
        custom_parameters_ = (
            reader.object(
                group_id=0XE95B0798
            )
            if flags(7) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            date=date_,
            admin_id=admin_id_,
            participant_id=participant_id_,
            g_a_or_b=g_a_or_b_,
            key_fingerprint=key_fingerprint_,
            protocol=protocol_,
            connections=connections_,
            start_date=start_date_,
            p2p_allowed=flags(5),
            video=flags(6),
            conference_supported=flags(8),
            custom_parameters=custom_parameters_
        )

class PhoneCallDiscarded(TLObject, family='TypePhoneCall'):
    """
    Indicates a discarded phone call
    """

    _id = 0X50CA4DE1
    _group_id = 0X943E32B8

    def __init__(
        self,
        id: int,
        need_rating: bool = False,
        need_debug: bool = False,
        video: bool = False,
        reason: Optional['TypePhoneCallDiscardReason'] = None,
        duration: Optional[int] = None
    ):

        """
        Indicates a discarded phone call

        Args:
            id (int): Call ID
            need_rating (bool, optional): Whether the server required the user to [rate](https://core.telegram.org/method/phone.setCallRating) the call
            need_debug (bool, optional): Whether the server required the client to [send](https://core.telegram.org/method/phone.saveCallDebug) the libtgvoip call debug data
            video (bool, optional): Whether the call was a video call
            reason (Optional['TypePhoneCallDiscardReason'], optional): Why was the phone call discarded
            duration (Optional[int], optional): Duration of the phone call in seconds
        """

        self.id = id
        self.need_rating = need_rating
        self.need_debug = need_debug
        self.video = video
        self.reason = reason
        self.duration = duration

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1M\xcaP' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.need_rating, 2)
                flags(self.need_debug, 3)
                flags(self.video, 6)
                writer.long(self.id)

                if flags(self.reason, 0):
                    writer.object(
                        self.reason,
                        group_id=0X7AB7DC85
                    )

                if flags(self.duration, 1):
                    writer.int(self.duration)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        reason_ = (
            reader.object(
                group_id=0X7AB7DC85
            )
            if flags(0) else None
        )

        duration_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            id=id_,
            need_rating=flags(2),
            need_debug=flags(3),
            video=flags(6),
            reason=reason_,
            duration=duration_
        )

TypePhoneCall = Union[
    PhoneCallEmpty,
    PhoneCallWaiting,
    PhoneCallRequested,
    PhoneCallAccepted,
    PhoneCall,
    PhoneCallDiscarded
]