
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .poll_answer import TypePollAnswer
    from .text_with_entities import TypeTextWithEntities
    from ...gadgets.byteutils import Reader


class Poll(TLObject, family='TypePoll'):
    """
    Poll
    """

    _id = 0X58747131
    _group_id = 0X9284C836

    def __init__(
        self,
        id: int,
        question: 'TypeTextWithEntities',
        answers: List['TypePollAnswer'],
        closed: bool = False,
        public_voters: bool = False,
        multiple_choice: bool = False,
        quiz: bool = False,
        close_period: Optional[int] = None,
        close_date: Optional[int] = None
    ):

        """
        Poll

        Args:
            id (int): ID of the poll
            question ('TypeTextWithEntities'): The question of the poll (only [Premium](https://core.telegram.org/api/premium) users can use [custom emoji entities](https://core.telegram.org/api/custom-emoji) here).
            answers (List['TypePollAnswer']): The possible answers, vote using [messages.sendVote](https://core.telegram.org/method/messages.sendVote).
            closed (bool, optional): Whether the poll is closed and doesn't accept any more answers
            public_voters (bool, optional): Whether cast votes are publicly visible to all users (non-anonymous poll)
            multiple_choice (bool, optional): Whether multiple options can be chosen as answer
            quiz (bool, optional): Whether this is a quiz (with wrong and correct answers, results shown in the return type)
            close_period (Optional[int], optional): Amount of time in seconds the poll will be active after creation, 5-600. Can't be used together with close_date.
            close_date (Optional[int], optional): Point in time (Unix timestamp) when the poll will be automatically closed. Must be at least 5 and no more than 600 seconds in the future; can't be used together with close_period.
        """

        self.id = id
        self.question = question
        self.answers = answers
        self.closed = closed
        self.public_voters = public_voters
        self.multiple_choice = multiple_choice
        self.quiz = quiz
        self.close_period = close_period
        self.close_date = close_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'1qtX' if boxed else b'') as writer:
            writer.long(self.id)
            with writer.flag() as flags:
                flags(self.closed, 0)
                flags(self.public_voters, 1)
                flags(self.multiple_choice, 2)
                flags(self.quiz, 3)
                writer.object(
                    self.question,
                    group_id=0X5D96896
                )
                writer.vector(
                    self.answers,
                    lambda value: writer.object(
                        value,
                        group_id=0X4A9B454B
                    )
                )

                if flags(self.close_period, 4):
                    writer.int(self.close_period)

                if flags(self.close_date, 5):
                    writer.int(self.close_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        flags = reader.flag()
        question_ = reader.object(
            group_id=0X5D96896
        )

        answers_ = reader.vector(
            lambda: reader.object(
                group_id=0X4A9B454B
            )
        )

        close_period_ = (
            reader.int()
            if flags(4) else None
        )

        close_date_ = (
            reader.int()
            if flags(5) else None
        )

        return cls(
            id=id_,
            question=question_,
            answers=answers_,
            closed=flags(0),
            public_voters=flags(1),
            multiple_choice=flags(2),
            quiz=flags(3),
            close_period=close_period_,
            close_date=close_date_
        )

TypePoll = Poll