
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .chat_admin_rights import TypeChatAdminRights
    from ...gadgets.byteutils import Reader


class RequestPeerTypeUser(TLObject, family='TypeRequestPeerType'):
    """
    Choose a user.
    """

    _id = 0X5F3B8A00
    _group_id = 0X459EEA1B

    def __init__(
        self,
        bot: bool = False,
        premium: bool = False
    ):

        """
        Choose a user.

        Args:
            bot (bool, optional): Whether to allow choosing only bots.
            premium (bool, optional): Whether to allow choosing only [Premium](https://core.telegram.org/api/premium) users.
        """

        self.bot = bot
        self.premium = premium

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x00\x8a;_' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.bot, 0):
                    writer.object(
                        self.bot,
                        group_id=0X43B904E1
                    )

                if flags(self.premium, 1):
                    writer.object(
                        self.premium,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        bot_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(0) else None
        )

        premium_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(1) else None
        )

        return cls(
            bot=bot_,
            premium=premium_
        )

class RequestPeerTypeChat(TLObject, family='TypeRequestPeerType'):
    """
    Choose a chat or supergroup
    """

    _id = 0XC9F06E1B
    _group_id = 0X459EEA1B

    def __init__(
        self,
        creator: bool = False,
        bot_participant: bool = False,
        has_username: bool = False,
        forum: bool = False,
        user_admin_rights: Optional['TypeChatAdminRights'] = None,
        bot_admin_rights: Optional['TypeChatAdminRights'] = None
    ):

        """
        Choose a chat or supergroup

        Args:
            creator (bool, optional): Whether to allow only choosing chats or supergroups that were created by the current user.
            bot_participant (bool, optional): Whether to allow only choosing chats or supergroups where the bot is a participant.
            has_username (bool, optional): If specified, allows only choosing channels with or without a username, according to the value of [Bool](https://core.telegram.org/type/Bool).
            forum (bool, optional): If specified, allows only choosing chats or supergroups that are or aren't [forums](https://core.telegram.org/api/forum), according to the value of [Bool](https://core.telegram.org/type/Bool).
            user_admin_rights (Optional['TypeChatAdminRights'], optional): If specified, allows only choosing chats or supergroups where the current user is an admin with at least the specified admin rights.
            bot_admin_rights (Optional['TypeChatAdminRights'], optional): If specified, allows only choosing chats or supergroups where the bot is an admin with at least the specified admin rights.
        """

        self.creator = creator
        self.bot_participant = bot_participant
        self.has_username = has_username
        self.forum = forum
        self.user_admin_rights = user_admin_rights
        self.bot_admin_rights = bot_admin_rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1bn\xf0\xc9' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.creator, 0)
                flags(self.bot_participant, 5)

                if flags(self.has_username, 3):
                    writer.object(
                        self.has_username,
                        group_id=0X43B904E1
                    )

                if flags(self.forum, 4):
                    writer.object(
                        self.forum,
                        group_id=0X43B904E1
                    )

                if flags(self.user_admin_rights, 1):
                    writer.object(
                        self.user_admin_rights,
                        group_id=0X2A03C5CB
                    )

                if flags(self.bot_admin_rights, 2):
                    writer.object(
                        self.bot_admin_rights,
                        group_id=0X2A03C5CB
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        has_username_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(3) else None
        )

        forum_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(4) else None
        )

        user_admin_rights_ = (
            reader.object(
                group_id=0X2A03C5CB
            )
            if flags(1) else None
        )

        bot_admin_rights_ = (
            reader.object(
                group_id=0X2A03C5CB
            )
            if flags(2) else None
        )

        return cls(
            creator=flags(0),
            bot_participant=flags(5),
            has_username=has_username_,
            forum=forum_,
            user_admin_rights=user_admin_rights_,
            bot_admin_rights=bot_admin_rights_
        )

class RequestPeerTypeBroadcast(TLObject, family='TypeRequestPeerType'):
    """
    Choose a channel
    """

    _id = 0X339BEF6C
    _group_id = 0X459EEA1B

    def __init__(
        self,
        creator: bool = False,
        has_username: bool = False,
        user_admin_rights: Optional['TypeChatAdminRights'] = None,
        bot_admin_rights: Optional['TypeChatAdminRights'] = None
    ):

        """
        Choose a channel

        Args:
            creator (bool, optional): Whether to allow only choosing channels that were created by the current user.
            has_username (bool, optional): If specified, allows only choosing channels with or without a username, according to the value of [Bool](https://core.telegram.org/type/Bool).
            user_admin_rights (Optional['TypeChatAdminRights'], optional): If specified, allows only choosing channels where the current user is an admin with at least the specified admin rights.
            bot_admin_rights (Optional['TypeChatAdminRights'], optional): If specified, allows only choosing channels where the bot is an admin with at least the specified admin rights.
        """

        self.creator = creator
        self.has_username = has_username
        self.user_admin_rights = user_admin_rights
        self.bot_admin_rights = bot_admin_rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'l\xef\x9b3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.creator, 0)

                if flags(self.has_username, 3):
                    writer.object(
                        self.has_username,
                        group_id=0X43B904E1
                    )

                if flags(self.user_admin_rights, 1):
                    writer.object(
                        self.user_admin_rights,
                        group_id=0X2A03C5CB
                    )

                if flags(self.bot_admin_rights, 2):
                    writer.object(
                        self.bot_admin_rights,
                        group_id=0X2A03C5CB
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        has_username_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(3) else None
        )

        user_admin_rights_ = (
            reader.object(
                group_id=0X2A03C5CB
            )
            if flags(1) else None
        )

        bot_admin_rights_ = (
            reader.object(
                group_id=0X2A03C5CB
            )
            if flags(2) else None
        )

        return cls(
            creator=flags(0),
            has_username=has_username_,
            user_admin_rights=user_admin_rights_,
            bot_admin_rights=bot_admin_rights_
        )

TypeRequestPeerType = Union[
    RequestPeerTypeUser,
    RequestPeerTypeChat,
    RequestPeerTypeBroadcast
]