
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class TextEmpty(TLObject, family='TypeRichText'):
    """
    Empty rich text element
    """

    _id = 0XDC3D824F
    _group_id = 0XB588E109


    def to_bytes(self, boxed: bool=True):
        return b'O\x82=\xdc' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class TextPlain(TLObject, family='TypeRichText'):
    """
    Plain text
    """

    _id = 0X744694E0
    _group_id = 0XB588E109

    def __init__(
        self,
        text: str
    ):

        """
        Plain text

        Args:
            text (str): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe0\x94Ft' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class TextBold(TLObject, family='TypeRichText'):
    """
    Bold text
    """

    _id = 0X6724ABC4
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Bold text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc4\xab$g' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextItalic(TLObject, family='TypeRichText'):
    """
    Italic text
    """

    _id = 0XD912A59C
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Italic text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9c\xa5\x12\xd9' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextUnderline(TLObject, family='TypeRichText'):
    """
    Underlined text
    """

    _id = 0XC12622C4
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Underlined text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc4"&\xc1' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextStrike(TLObject, family='TypeRichText'):
    """
    Strikethrough text
    """

    _id = 0X9BF8BB95
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Strikethrough text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x95\xbb\xf8\x9b' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextFixed(TLObject, family='TypeRichText'):
    """
    fixed-width rich text
    """

    _id = 0X6C3F19B9
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        fixed-width rich text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb9\x19?l' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextUrl(TLObject, family='TypeRichText'):
    """
    Link
    """

    _id = 0X3C2884C1
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText',
        url: str,
        webpage_id: int
    ):

        """
        Link

        Args:
            text ('TypeRichText'): Text of link
            url (str): Webpage HTTP URL
            webpage_id (int): If a preview was already generated for the page, the page ID
        """

        self.text = text
        self.url = url
        self.webpage_id = webpage_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc1\x84(<' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.string(self.url)
            writer.long(self.webpage_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        url_ = reader.string()
        webpage_id_ = reader.long()

        return cls(
            text=text_,
            url=url_,
            webpage_id=webpage_id_
        )

class TextEmail(TLObject, family='TypeRichText'):
    """
    Rich text email link
    """

    _id = 0XDE5A0DD6
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText',
        email: str
    ):

        """
        Rich text email link

        Args:
            text ('TypeRichText'): Link text
            email (str): Email address
        """

        self.text = text
        self.email = email

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\rZ\xde' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.string(self.email)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        email_ = reader.string()

        return cls(
            text=text_,
            email=email_
        )

class TextConcat(TLObject, family='TypeRichText'):
    """
    Concatenation of rich texts
    """

    _id = 0X7E6260D7
    _group_id = 0XB588E109

    def __init__(
        self,
        texts: List['TypeRichText']
    ):

        """
        Concatenation of rich texts

        Args:
            texts (List['TypeRichText']): Concatenated rich texts
        """

        self.texts = texts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd7`b~' if boxed else b'') as writer:
            writer.vector(
                self.texts,
                lambda value: writer.object(
                    value,
                    group_id=0XB588E109
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        texts_ = reader.vector(
            lambda: reader.object(
                group_id=0XB588E109
            )
        )

        return cls(
            texts=texts_
        )

class TextSubscript(TLObject, family='TypeRichText'):
    """
    Subscript text
    """

    _id = 0XED6A8504
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Subscript text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x04\x85j\xed' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextSuperscript(TLObject, family='TypeRichText'):
    """
    Superscript text
    """

    _id = 0XC7FB5E01
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Superscript text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x01^\xfb\xc7' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextMarked(TLObject, family='TypeRichText'):
    """
    Highlighted text
    """

    _id = 0X34B8621
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText'
    ):

        """
        Highlighted text

        Args:
            text ('TypeRichText'): Text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'!\x86K\x03' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        return cls(
            text=text_
        )

class TextPhone(TLObject, family='TypeRichText'):
    """
    Rich text linked to a phone number
    """

    _id = 0X1CCB966A
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText',
        phone: str
    ):

        """
        Rich text linked to a phone number

        Args:
            text ('TypeRichText'): Text
            phone (str): Phone number
        """

        self.text = text
        self.phone = phone

    def to_bytes(self, boxed: bool=True):
        with Writer(b'j\x96\xcb\x1c' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.string(self.phone)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        phone_ = reader.string()

        return cls(
            text=text_,
            phone=phone_
        )

class TextImage(TLObject, family='TypeRichText'):
    """
    Inline image
    """

    _id = 0X81CCF4F
    _group_id = 0XB588E109

    def __init__(
        self,
        document_id: int,
        w: int,
        h: int
    ):

        """
        Inline image

        Args:
            document_id (int): Document ID
            w (int): Width
            h (int): Height
        """

        self.document_id = document_id
        self.w = w
        self.h = h

    def to_bytes(self, boxed: bool=True):
        with Writer(b'O\xcf\x1c\x08' if boxed else b'') as writer:
            writer.long(self.document_id)
            writer.int(self.w)
            writer.int(self.h)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        document_id_ = reader.long()
        w_ = reader.int()
        h_ = reader.int()

        return cls(
            document_id=document_id_,
            w=w_,
            h=h_
        )

class TextAnchor(TLObject, family='TypeRichText'):
    """
    Text linking to another section of the page
    """

    _id = 0X35553762
    _group_id = 0XB588E109

    def __init__(
        self,
        text: 'TypeRichText',
        name: str
    ):

        """
        Text linking to another section of the page

        Args:
            text ('TypeRichText'): Text
            name (str): Section name
        """

        self.text = text
        self.name = name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'b7U5' if boxed else b'') as writer:
            writer.object(
                self.text,
                group_id=0XB588E109
            )
            writer.string(self.name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.object(
            group_id=0XB588E109
        )

        name_ = reader.string()

        return cls(
            text=text_,
            name=name_
        )

TypeRichText = Union[
    TextEmpty,
    TextPlain,
    TextBold,
    TextItalic,
    TextUnderline,
    TextStrike,
    TextFixed,
    TextUrl,
    TextEmail,
    TextConcat,
    TextSubscript,
    TextSuperscript,
    TextMarked,
    TextPhone,
    TextImage,
    TextAnchor
]