
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .secure_password_kdf_algo import TypeSecurePasswordKdfAlgo


class SecureSecretSettings(TLObject, family='TypeSecureSecretSettings'):
    """
    Secure settings
    """

    _id = 0X1527BCAC
    _group_id = 0XC2D666DE

    def __init__(
        self,
        secure_algo: 'TypeSecurePasswordKdfAlgo',
        secure_secret: bytes,
        secure_secret_id: int
    ):

        """
        Secure settings

        Args:
            secure_algo ('TypeSecurePasswordKdfAlgo'): Secure KDF algo
            secure_secret (bytes): Secure secret
            secure_secret_id (int): Secret ID
        """

        self.secure_algo = secure_algo
        self.secure_secret = secure_secret
        self.secure_secret_id = secure_secret_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xac\xbc'\x15" if boxed else b'') as writer:
            writer.object(
                self.secure_algo,
                group_id=0X3C26E360
            )
            writer.bytes(self.secure_secret)
            writer.long(self.secure_secret_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        secure_algo_ = reader.object(
            group_id=0X3C26E360
        )

        secure_secret_ = reader.bytes()
        secure_secret_id_ = reader.long()

        return cls(
            secure_algo=secure_algo_,
            secure_secret=secure_secret_,
            secure_secret_id=secure_secret_id_
        )

TypeSecureSecretSettings = SecureSecretSettings